"use strict";
const utils_1 = require("../utils");
const defaultOptions = [];
const rule = utils_1.ruleCreator({
    defaultOptions,
    meta: {
        docs: {
            category: "Best Practices",
            description: "Forbids single-character type parameters.",
            recommended: false,
        },
        fixable: undefined,
        messages: {
            forbidden: `Single-character type parameters are forbidden. Choose a more descriptive name for "{{name}}"`,
            prefix: `Type parameter "{{name}}" does not have prefix "{{prefix}}"`,
        },
        schema: [
            {
                properties: {
                    prefix: { type: "string" },
                },
                type: "object",
            },
        ],
        type: "problem",
    },
    name: "no-t",
    create: (context, unused) => {
        const [{ prefix = "" } = {}] = context.options;
        return {
            "TSTypeParameter > Identifier[name=/^.$/]": (node) => context.report({
                data: { name: node.name },
                messageId: "forbidden",
                node,
            }),
            "TSTypeParameter > Identifier[name=/^.{2,}$/]": (node) => {
                const { name } = node;
                if (prefix && name.indexOf(prefix) !== 0) {
                    context.report({
                        data: { name, prefix },
                        messageId: "prefix",
                        node,
                    });
                }
            },
        };
    },
});
module.exports = rule;
