"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findTaggedNames = void 0;
const tsquery_1 = require("@phenomnomnominal/tsquery");
const ts = require("typescript");
function findTaggedNames(tagName, program) {
    const taggedNames = new Set();
    program.getSourceFiles().forEach((sourceFile) => {
        if (sourceFile.text.indexOf(`@${tagName}`) === -1) {
            return;
        }
        const nodes = tsquery_1.tsquery(sourceFile, `ClassDeclaration, Constructor, EnumDeclaration, EnumMember, FunctionDeclaration, GetAccessor, InterfaceDeclaration, MethodDeclaration, MethodSignature, PropertyDeclaration, PropertySignature, SetAccessor, TypeAliasDeclaration, VariableDeclaration`);
        nodes.forEach((node) => {
            const tags = ts.getJSDocTags(node);
            if (!tags.some((tag) => tag.tagName.text === tagName)) {
                return;
            }
            if (ts.isConstructorDeclaration(node)) {
                const { parent } = node;
                const { name } = parent;
                if (name === null || name === void 0 ? void 0 : name.text) {
                    taggedNames.add(name.text);
                }
            }
            else {
                const { name } = node;
                if (name === null || name === void 0 ? void 0 : name.text) {
                    taggedNames.add(name.text);
                }
            }
        });
    });
    return taggedNames;
}
exports.findTaggedNames = findTaggedNames;
