Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var core_1 = require("@sentry/core");
var utils_1 = require("@sentry/utils");
var fs_1 = require("fs");
var lru_map_1 = require("lru_map");
var FILE_CONTENT_CACHE = new lru_map_1.LRUMap(100);
var DEFAULT_LINES_OF_CONTEXT = 7;
// TODO: Replace with promisify when minimum supported node >= v8
function readTextFileAsync(path) {
    return new Promise(function (resolve, reject) {
        fs_1.readFile(path, 'utf8', function (err, data) {
            if (err)
                reject(err);
            else
                resolve(data);
        });
    });
}
/**
 * Resets the file cache. Exists for testing purposes.
 * @hidden
 */
function resetFileContentCache() {
    FILE_CONTENT_CACHE.clear();
}
exports.resetFileContentCache = resetFileContentCache;
/** Add node modules / packages to the event */
var ContextLines = /** @class */ (function () {
    function ContextLines(_options) {
        if (_options === void 0) { _options = {}; }
        this._options = _options;
        /**
         * @inheritDoc
         */
        this.name = ContextLines.id;
    }
    /**
     * @inheritDoc
     */
    ContextLines.prototype.setupOnce = function (addGlobalEventProcessor) {
        var _this = this;
        var _a, _b;
        // This is only here to copy frameContextLines from init options if it hasn't
        // been set via this integrations constructor.
        //
        // TODO: Remove on next major!
        if (this._options.frameContextLines === undefined) {
            var initOptions = (_a = core_1.getCurrentHub().getClient()) === null || _a === void 0 ? void 0 : _a.getOptions();
            // eslint-disable-next-line deprecation/deprecation
            this._options.frameContextLines = (_b = initOptions) === null || _b === void 0 ? void 0 : _b.frameContextLines;
        }
        var contextLines = this._options.frameContextLines !== undefined ? this._options.frameContextLines : DEFAULT_LINES_OF_CONTEXT;
        addGlobalEventProcessor(function (event) { return _this.addSourceContext(event, contextLines); });
    };
    /** Processes an event and adds context lines */
    ContextLines.prototype.addSourceContext = function (event, contextLines) {
        var _a, _b, _c;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var frames, filenames, frames_1, frames_1_1, frame, sourceFiles, frames_2, frames_2_1, frame, lines;
            var e_1, _d, e_2, _e;
            return tslib_1.__generator(this, function (_f) {
                switch (_f.label) {
                    case 0:
                        frames = (_c = (_b = (_a = event.exception) === null || _a === void 0 ? void 0 : _a.values) === null || _b === void 0 ? void 0 : _b[0].stacktrace) === null || _c === void 0 ? void 0 : _c.frames;
                        if (!(frames && contextLines > 0)) return [3 /*break*/, 2];
                        filenames = new Set();
                        try {
                            for (frames_1 = tslib_1.__values(frames), frames_1_1 = frames_1.next(); !frames_1_1.done; frames_1_1 = frames_1.next()) {
                                frame = frames_1_1.value;
                                if (frame.filename) {
                                    filenames.add(frame.filename);
                                }
                            }
                        }
                        catch (e_1_1) { e_1 = { error: e_1_1 }; }
                        finally {
                            try {
                                if (frames_1_1 && !frames_1_1.done && (_d = frames_1.return)) _d.call(frames_1);
                            }
                            finally { if (e_1) throw e_1.error; }
                        }
                        return [4 /*yield*/, readSourceFiles(filenames)];
                    case 1:
                        sourceFiles = _f.sent();
                        try {
                            for (frames_2 = tslib_1.__values(frames), frames_2_1 = frames_2.next(); !frames_2_1.done; frames_2_1 = frames_2.next()) {
                                frame = frames_2_1.value;
                                if (frame.filename && sourceFiles[frame.filename]) {
                                    try {
                                        lines = sourceFiles[frame.filename].split('\n');
                                        utils_1.addContextToFrame(lines, frame, contextLines);
                                    }
                                    catch (e) {
                                        // anomaly, being defensive in case
                                        // unlikely to ever happen in practice but can definitely happen in theory
                                    }
                                }
                            }
                        }
                        catch (e_2_1) { e_2 = { error: e_2_1 }; }
                        finally {
                            try {
                                if (frames_2_1 && !frames_2_1.done && (_e = frames_2.return)) _e.call(frames_2);
                            }
                            finally { if (e_2) throw e_2.error; }
                        }
                        _f.label = 2;
                    case 2: return [2 /*return*/, event];
                }
            });
        });
    };
    /**
     * @inheritDoc
     */
    ContextLines.id = 'ContextLines';
    return ContextLines;
}());
exports.ContextLines = ContextLines;
/**
 * This function reads file contents and caches them in a global LRU cache.
 *
 * @param filenames Array of filepaths to read content from.
 */
function readSourceFiles(filenames) {
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var sourceFiles, filenames_1, filenames_1_1, filename, cachedFile, content, _1, e_3_1;
        var e_3, _a;
        return tslib_1.__generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    sourceFiles = {};
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 9, 10, 11]);
                    filenames_1 = tslib_1.__values(filenames), filenames_1_1 = filenames_1.next();
                    _b.label = 2;
                case 2:
                    if (!!filenames_1_1.done) return [3 /*break*/, 8];
                    filename = filenames_1_1.value;
                    cachedFile = FILE_CONTENT_CACHE.get(filename);
                    // We have a cache hit
                    if (cachedFile !== undefined) {
                        // If stored value is null, it means that we already tried, but couldn't read the content of the file. Skip.
                        if (cachedFile === null) {
                            return [3 /*break*/, 7];
                        }
                        // Otherwise content is there, so reuse cached value.
                        sourceFiles[filename] = cachedFile;
                        return [3 /*break*/, 7];
                    }
                    content = null;
                    _b.label = 3;
                case 3:
                    _b.trys.push([3, 5, , 6]);
                    return [4 /*yield*/, readTextFileAsync(filename)];
                case 4:
                    content = _b.sent();
                    return [3 /*break*/, 6];
                case 5:
                    _1 = _b.sent();
                    return [3 /*break*/, 6];
                case 6:
                    FILE_CONTENT_CACHE.set(filename, content);
                    sourceFiles[filename] = content;
                    _b.label = 7;
                case 7:
                    filenames_1_1 = filenames_1.next();
                    return [3 /*break*/, 2];
                case 8: return [3 /*break*/, 11];
                case 9:
                    e_3_1 = _b.sent();
                    e_3 = { error: e_3_1 };
                    return [3 /*break*/, 11];
                case 10:
                    try {
                        if (filenames_1_1 && !filenames_1_1.done && (_a = filenames_1.return)) _a.call(filenames_1);
                    }
                    finally { if (e_3) throw e_3.error; }
                    return [7 /*endfinally*/];
                case 11: return [2 /*return*/, sourceFiles];
            }
        });
    });
}
//# sourceMappingURL=contextlines.js.map