'use strict'

const JSONStableStringify = require('json-stable-stringify')

module.exports = (key) => {
  const fingerprint = key.spkiFingerprint()

  function sign (url, method, body) {
    const now = Date.now()

    const urlParsed = new URL(url)

    const toSign = {
      method: method.toLowerCase(),
      path: urlParsed.pathname,
      now,
      query: []
    }

    for (const [key, value] of urlParsed.searchParams.entries()) {
      toSign.query.push([key, value])
    }

    if (body) {
      toSign.payload = body
    }

    return {
      'x-sig-now': now,
      'x-sig-fingerprint': fingerprint,
      'x-sig': key.sign(JSONStableStringify(toSign)).toString('base64')
    }
  }

  return {
    signFetch (url, method, body) {
      return [url, {
        method,
        headers: {
          ...(body
            ? {
              'content-type': 'application/json'
            }
            : {}),
          ...sign(url, method, body)
        },
        body: body ? JSON.stringify(body) : undefined
      }]
    },
    sign,
    fingerprint
  }
}
