'use strict'

const fs = require('fs')
const crypto = require('crypto')

const { PrivateKey, PublicKey } = require('./pair')

module.exports = {
  generateKeyPair (type, modulusLength, extraOptions = {}) {
    const { publicKey, privateKey } = crypto.generateKeyPairSync(type, {
      modulusLength,
      ...extraOptions
    })

    const priv = PrivateKey.fromKeyObject(privateKey)
    priv.pub = PublicKey.fromKeyObject(publicKey)

    return priv
  },

  private: PrivateKey,
  public: PublicKey,

  get machineId () {
    // TODO: error only linux
    return String(fs.readFileSync('/etc/machine-id')).trim()
  }
}
