#!/nix/store/a7k5vvhgdi6lbrv9v4y0fj54f32z9bii-nodejs-16.14.0/bin/node

/* eslint-disable no-process-exit */

'use strict'

import _Cookie from '@xeredo/common/src/modules/cookie.js' // aquire cookie

import debug from 'debug'

import colors from 'colors/safe.js'

import net from '@xeredo/common/src/modules/net.js'

import _KVBackend from '@xeredo/common/src/modules/kv/kv-http-backend.js'
import _KVStorage from '@xeredo/common/src/modules/kv/kv-storage.js'

import I18N from '@xeredo/common/src/common/i18n.js'
import Locales from '../locales/index.js'

import yargs from 'yargs'
import { hideBin } from 'yargs/helpers'

import Enquirer from '@xeredo/common/src/modules/enquirer.js'
// import { enquirer as validateEnquirer } from 'enquirer'

import * as util from '@xeredo/common/src/modules/util.js'

import Backend from '@xeredo/common/src/modules/backend.js'

const Cookie = _Cookie('/var/lib/guardian')
const log = debug('guardian')

const BACKEND_URL = 'http://[::1]:14467'
const KVBackend = _KVBackend(`${BACKEND_URL}/storage`, Cookie.headers)

const { translate, setLanguage } = I18N({
  messages: Locales
})

const storage = _KVStorage(KVBackend)

const _enq = Enquirer(enquirer => {
  // enquirer.use(validateEnquirer)
}, translate)

const { prompt } = _enq
const { info, error } = util

const cliCommon = {
  $t: translate,
  prompt,
  storage
}

const $t = translate
const b = Backend(BACKEND_URL, Cookie.headers, { long: (await import('./long-cli.js')).default, ...cliCommon })
cliCommon.$b = b

// const configStuff = require('./config-website')

async function main () {
  await b.doConnect()

  yargs(hideBin(process.argv))
    .scriptName('guardian')
    /* .command('import-pssl', 'import /etc/default/proxy from paedML SSL v1 product', async argv => {

    })
    .command('config', 'configure guardian directly', yargs => yargs, async argv => {
      // (<type> <id/slug> <verb/type>....)*
      // this gives us:
      // domain example.com create
      // domain example.com route @ add
    }) */
    .command('setup', 'setup and configure guardian via the command-line', yargs => yargs, async argv => {
      if (util.IS_DEBUG_VM) {
        info('debug vm detected, skipping actual network setup')
      }

      let res

      /* Setup network */

      await net.cli(cliCommon)

      info.wait(colors.cyan($t('common.change.apply')))
      await b.doLong('/config/network')
      info.success(($t('common.change.success')))

      let checkAttempts = 3

      while (checkAttempts--) {
        info.wait(($t('common.net.x_check')))
        res = await b.post('/net/checkNet')
        if (res.success) {
          info.success($t(...res.display))
          break
        } else {
          error($t(...res.display))

          if (!checkAttempts) {
            error($t('common.net.x_required'))
            process.exit(2)
          }

          info.wait($t('common.net.x_check_again_wait', 3 - checkAttempts, 3))
          await new Promise((resolve, reject) => setTimeout(resolve, 1000))
        }
      }

      /* Inform of webinterface */

      const { urls } = await b.get('/net/getAddrs')

      info($t('common.webinterface.continue'))
      info($t('common.webinterface.reachable_at'))
      urls.forEach(addr => {
        info(` - ${addr}`)
      })

      /* Setup domains */

      // await configStuff(cliCommon)

      /* Verify */

      /* info.wait($t('verify.info.running'))

      res = await b.post('/verify')

      if (res.error) {
        error($t(...res.error))
      } else {
        info($t('verify.info.result'))

        for (const hostname in res.r) { // eslint-disable-line guard-for-in
          const hostnameResult = res.r[hostname]
          info(`  ${hostname}: ${$t(...hostnameResult.summary)}`)
          info(`    IPv4: ${$t(...hostnameResult.v4Display)}`)
          info(`    IPv6: ${$t(...hostnameResult.v6Display)}`)
        }

        if (!res.success) {
          // TODO: ask user if they want to continue despite errors, re-test or cancel
        }
      }

      info.wait(colors.cyan($t('common.change.apply')))
      await b.doLong('/config/guardian/apply')
      info.success(($t('common.change.success'))) */

      // TODO: figure out what's keeping the process alive instead of this
      process.exit(0)

      /*

  inital:
  - domain eingeben
  - checkbox: hauptdomain verwenden
  - ip: ziel-server ip

  --

  next:

  Domains:
  - () xyz.de
    => Dienste, Plugins und Subdomains konfigurieren
    => Verwalten

      */
    })
    .option('colors', {
      alias: 'c',
      type: 'boolean',
      description: 'Enable colors in output',
      default: true,
      coerce: v => v ? colors.enable() : colors.disable()
    })
    .demandCommand(1)
    .help()
    .parse()
}

main().then(() => {}, err => {
  console.error(err) // eslint-disable-line no-console
  process.exit(1)
})
