import Config from './config.vue'

function ConfigPlugin (Vue) {
  const mkConfigTemplate = (name, template) => {
    Vue.component('config-' + name, {
      props: ['error', 'id', 'display', 'value'],
      computed: {
        valueProp: {
          get () {
            return this.value
          },
          set (value) {
            return this.$emit('update:value', value)
          }
        }
      },
      template
    })
  }

  Vue.component('configerror', {
    props: ['error'],
    template: '<div v-if="error" class="config-error"><i class="fas fa-exclamation-triangle"></i> {{ error }}</div>'
  })

  mkConfigTemplate('text', '<label :for="id">{{ display }}</label><input :id="id" type="text" v-model="valueProp"><configerror :error="error" />')
  mkConfigTemplate('number', '<label :for="id">{{ display }}</label><input :id="id" type="number" v-model="valueProp"><configerror :error="error" />')
  mkConfigTemplate('checkbox', '<input :id="id" type="checkbox" v-model="valueProp"><label :for="id">{{ display }}</label><configerror :error="error" />')
  mkConfigTemplate('textfield', '<label :for="id">{{ display }}</label><configerror :error="error" /><br><textarea spellcheck="false" rows="14" style="width: 100%; box-sizing: border-box;" :id="id" v-model="valueProp"></textarea>')

  Vue.component('config', Config)
}

export default ConfigPlugin
