import Nes from '@hapi/nes'
import fetch from './fetch.js'

export default (base, extraHeaders = {}, { $t, long: longClient }) => {
  async function req (url, method, body) {
    const req = await fetch(`${base}${url}`, body
      ? {
          method,
          body: JSON.stringify(body),
          headers: { 'Content-Type': 'application/json', ...extraHeaders },
          credentials: 'include'
        }
      : { method, headers: extraHeaders, credentials: 'include' })

    const res = await req.json()

    if (res.error) {
      if (Array.isArray(res.error)) { // error is array means translated error for ui, this means we should return this as-is
        return res
      }

      throw new Error(res.error)
    }

    if (req.status > 299) {
      throw new Error(`Request failed ${req.status} ${req.statusText}`)
    }

    return res
  }

  const client = new Nes.Client(base.replace('http', 'ws'))

  async function doConnect () {
    await client.connect({ auth: { headers: extraHeaders } })
  }

  return {
    post (url, body) {
      return req(url, 'POST', body)
    },
    get (url) {
      return req(url, 'GET')
    },
    doConnect (h) {
      if (h) {
        extraHeaders = h
      }

      return doConnect()
    },
    async doLong (url, extraHandlers = {}) {
      const long = await req(url, 'POST')

      return longClient({ extraHandlers, extraHeaders, base, client, $t, long })
    },
    attachLong (id, extraHandlers = {}) {
      return longClient({ extraHandlers, extraHeaders, base, client, $t, long: { id } })
    }
  }
}
