import Enquirer from 'enquirer'

import * as Types from './types.js'
import { error } from './util.js'

/*

Each prompt takes an options object (aka "question" object), that implements the following interface:

{
  // required
  type: string | function,
  name: string | function,
  message: string | function | async function,

  // optional
  skip: boolean | function | async function,
  initial: string | function | async function,
  format: function | async function,
  result: function | async function,
  validate: function | async function,
}

*/

export default (setup, $t, extraTypes = {}) => {
  const types = Object.assign({}, Types, extraTypes)

  const enquirer = new Enquirer()

  setup(enquirer)

  async function prompt (key, _ = {}) {
    const { type, promptType = 'input', message, required = true, ...options } = _

    // key is a storage object, it has .set(), .get(), .delete()

    // TODO: use default promptType from promptTypes[types[type].u]
    const typeValidate = (types[type] || {}).v || (v => v)

    let result = await enquirer.prompt({
      type: promptType,
      ...options,

      name: 'result',

      message,
      initial: await key.get(),

      validate: value => {
        try {
          typeValidate(value)
        } catch (error) {
          if (error.trId) {
            return $t(error.trId, ...error.trParams, value)
          }

          return String(error)
        }

        if (value === undefined && required) {
          return $t('common.keyRequired', key)
        }

        return true
      },
      result: value => {
        return typeValidate(value)
      }
    })

    result = result.result

    if (result === undefined) {
      // TODO: should we load current or should we instead call key.delete() ?
      result = await key.get()
    } else {
      await key.set(result)
    }

    return result
  }

  return {
    prompt
  }
}
