const p = (base, add) => {
  if (!add) {
    return base
  }

  return base.concat(Array.isArray(add) ? add : [add])
}

export default backend => {
  function subStorage (path = []) {
    return {
      sub: additionalPath => subStorage(p(path, additionalPath)),
      get: additionalPath => {
        const full = p(path, additionalPath)
        return backend.get(full)
      },
      set: (value, additionalPath) => {
        const full = p(path, additionalPath)
        return backend.set(full, value)
      },
      delete: additionalPath => {
        const full = p(path, additionalPath)
        return backend.delete(full)
      }
    }
  }

  return subStorage([])
}
