export default (server, db, { user, oidc }) => {
  server.auth.strategy('session', 'xauth', {
    openid: oidc,
    scim: {
      enable: true,
      syncInterval: 1000 * 60 * 5
    },
    state: {
      session: {
        validFor: 1000 * 60 * 60 * 24, // 1 day
        async create (sid, data, expiresAt) { // sid is oauth, id is our session id
          const res = await db('sessions').insert({ data, sid, expiresAt }).returning('id')

          return res[0].id
        },
        async fetch (id) {
          const ses = await db('sessions').select('data').where({ id }).first()
          return ses.data
        },
        async delete (id) {
          return db('sessions').where({ id }).del()
        }
      },
      lock: {
        aquire: () => {},
        release: () => {}
      },
      kv: {
        get: () => {},
        set: () => {},
        del: () => {}
      },
      user
    }
  })
}
