import locales from './locales/index.js'

export const route = {
  name: 'exchange.name',
  desc: 'exchange.desc',
  locales,
  config: {
    address: {
      display: 'exchange.address',
      type: 'host'
    }
  },
  create (getConfig) {
    return {
      requires () {
        return {}
      },

      verify (verify) {
        const { address } = getConfig()
        return verify.verifyURL(`https://${address}`)
      },

      // since this is a route, we get the domain, sub, cert predefined, but we can request extra certs if needed
      configure ({ cert: serviceCert, full }, { fromTemplate }) {
        const { cert, key } = serviceCert
        const { address } = getConfig()

        return {
          nginx: {
            sites: {
              ['exchange-' + full + '.conf']: fromTemplate('exchange.conf', {
                CERT: cert,
                KEY: key,
                NAME: full,
                HOST: address
              })
            }
          },
          firewall: []
        }
      }
    }
  }
}
