import fs from 'fs'
import path from 'path'

import { fileURLToPath } from 'url'

const __dirname = path.dirname(fileURLToPath(import.meta.url))

function lookup (paths, ...target) {
  const res = paths.map(p => path.join(p, ...target)).filter(p => fs.existsSync(p))[0]

  if (!res) {
    throw new Error(`Lookup failed, couldn't find any ${target.join(' / ')} in ${paths.join(', ')}`)
  }

  return res
}

export default ({ pluginPath = false }) => {
  const lookupPaths = []
  if (pluginPath) {
    lookupPaths.push(pluginPath)
  }

  lookupPaths.push(__dirname)

  return {
    fromTemplate: (file, replace) => {
      let content = String(fs.readFileSync(lookup(lookupPaths, 'template', file)))

      for (const key in replace) { // eslint-disable-line guard-for-in
        const value = replace[key]

        content = content.replace(new RegExp(`\\{${key.toUpperCase()}\\}`, 'gm'), value)
      }

      return content
    },
    lookup: (...target) => lookup(lookupPaths, ...target)
  }
}
