import fs from 'fs'
import path from 'path'

import { fileURLToPath } from 'url'

const __dirname = path.dirname(fileURLToPath(import.meta.url))

const dir = path.join(__dirname, 'env')

// load the correct env from env/

// check if env/this.js exists and load that
// else check for XEREDO_ENV and load that
// else load "stage"

function getEnv () {
  if (fs.existsSync(path.join(dir, 'this.js'))) {
    return 'this'
  }

  if (process.env.XEREDO_ENV) {
    return process.env.XEREDO_ENV
  }

  return 'stage'
}

export default (await import(path.join(dir, getEnv() + '.js'))).default
