import fetch from 'node-fetch'
import _Errors from './errors.js'

import crypto from 'crypto'
import fs from 'fs'

export const Errors = _Errors
export const ErrorToTranslated = Object.keys(Errors).map(key => [Errors[key], `verify.result.${key.toLowerCase()}`]).reduce((out, next) => {
  out[next[0]] = next[1]

  return out
}, {})

export default ({ endpoint = 'https://verify.xeredo.it/check', signRequest }) => async hostnames => {
  const token = crypto.randomBytes(16).toString('hex') // 16 binary -> 32 hex

  fs.writeFileSync(`/tmp/verify-token/${token}`, token)

  let res = await fetch(...signRequest(endpoint, 'POST', {
    token,
    hostnames
  }))

  if (res.status !== 200) {
    throw Object.assign(new Error(`Verify check failed: ${res.status} ${res.statusText}`), { status: res.status })
  }

  res = await res.json()

  const out = { r: {}, success: true }

  for (const hostname in res.results) { // eslint-disable-line guard-for-in
    const [v4, v6] = res.results[hostname]

    const success =
      (v4 === 20 && v6 === 0) ||
      (v4 === 0 && v6 === 20) ||
      (v4 === 0 && v6 === 0)

    if (!success) {
      out.success = false
    }

    let summary

    if (v4 === 0 && v6 === 0) {
      summary = ['verify.summary.reachable_46']
    } else if (v4 === 20 && v6 === 0) {
      summary = ['verify.summary.reachable_6']
    } else if (v4 === 0 && v6 === 20) {
      summary = ['verify.summary.reachable_4']
    } else {
      summary = ['verify.summary.not_reachable']
    }

    out.r[hostname] = {
      summary,
      success,
      v4,
      v4Display: [ErrorToTranslated[v4]],
      v6,
      v6Display: [ErrorToTranslated[v6]]
    }
  }

  return out
}
