# Release 17.03 ("Gorilla", 2017/03/31) {#sec-release-17.03}

## Highlights {#sec-release-17.03-highlights}

In addition to numerous new and upgraded packages, this release has the following highlights:

- Nixpkgs is now extensible through overlays. See the [Nixpkgs manual](https://nixos.org/nixpkgs/manual/#sec-overlays-install) for more information.

- This release is based on Glibc 2.25, GCC 5.4.0 and systemd 232. The default Linux kernel is 4.9 and Nix is at 1.11.8.

- The default desktop environment now is KDE\'s Plasma 5. KDE 4 has been removed

- The setuid wrapper functionality now supports setting capabilities.

- X.org server uses branch 1.19. Due to ABI incompatibilities, `ati_unfree` keeps forcing 1.17 and `amdgpu-pro` starts forcing 1.18.

- Cross compilation has been rewritten. See the nixpkgs manual for details. The most obvious breaking change is that in derivations there is no `.nativeDrv` nor `.crossDrv` are now cross by default, not native.

- The `overridePackages` function has been rewritten to be replaced by [ overlays](https://nixos.org/nixpkgs/manual/#sec-overlays-install)

- Packages in nixpkgs can be marked as insecure through listed vulnerabilities. See the [Nixpkgs manual](https://nixos.org/nixpkgs/manual/#sec-allow-insecure) for more information.

- PHP now defaults to PHP 7.1

## New Services {#sec-release-17.03-new-services}

The following new services were added since the last release:

- `hardware/ckb.nix`

- `hardware/mcelog.nix`

- `hardware/usb-wwan.nix`

- `hardware/video/capture/mwprocapture.nix`

- `programs/adb.nix`

- `programs/chromium.nix`

- `programs/gphoto2.nix`

- `programs/java.nix`

- `programs/mtr.nix`

- `programs/oblogout.nix`

- `programs/vim.nix`

- `programs/wireshark.nix`

- `security/dhparams.nix`

- `services/audio/ympd.nix`

- `services/computing/boinc/client.nix`

- `services/continuous-integration/buildbot/master.nix`

- `services/continuous-integration/buildbot/worker.nix`

- `services/continuous-integration/gitlab-runner.nix`

- `services/databases/riak-cs.nix`

- `services/databases/stanchion.nix`

- `services/desktops/gnome3/gnome-terminal-server.nix`

- `services/editors/infinoted.nix`

- `services/hardware/illum.nix`

- `services/hardware/trezord.nix`

- `services/logging/journalbeat.nix`

- `services/mail/offlineimap.nix`

- `services/mail/postgrey.nix`

- `services/misc/couchpotato.nix`

- `services/misc/docker-registry.nix`

- `services/misc/errbot.nix`

- `services/misc/geoip-updater.nix`

- `services/misc/gogs.nix`

- `services/misc/leaps.nix`

- `services/misc/nix-optimise.nix`

- `services/misc/ssm-agent.nix`

- `services/misc/sssd.nix`

- `services/monitoring/arbtt.nix`

- `services/monitoring/netdata.nix`

- `services/monitoring/prometheus/default.nix`

- `services/monitoring/prometheus/alertmanager.nix`

- `services/monitoring/prometheus/blackbox-exporter.nix`

- `services/monitoring/prometheus/json-exporter.nix`

- `services/monitoring/prometheus/nginx-exporter.nix`

- `services/monitoring/prometheus/node-exporter.nix`

- `services/monitoring/prometheus/snmp-exporter.nix`

- `services/monitoring/prometheus/unifi-exporter.nix`

- `services/monitoring/prometheus/varnish-exporter.nix`

- `services/monitoring/sysstat.nix`

- `services/monitoring/telegraf.nix`

- `services/monitoring/vnstat.nix`

- `services/network-filesystems/cachefilesd.nix`

- `services/network-filesystems/glusterfs.nix`

- `services/network-filesystems/ipfs.nix`

- `services/networking/dante.nix`

- `services/networking/dnscrypt-wrapper.nix`

- `services/networking/fakeroute.nix`

- `services/networking/flannel.nix`

- `services/networking/htpdate.nix`

- `services/networking/miredo.nix`

- `services/networking/nftables.nix`

- `services/networking/powerdns.nix`

- `services/networking/pdns-recursor.nix`

- `services/networking/quagga.nix`

- `services/networking/redsocks.nix`

- `services/networking/wireguard.nix`

- `services/system/cgmanager.nix`

- `services/torrent/opentracker.nix`

- `services/web-apps/atlassian/confluence.nix`

- `services/web-apps/atlassian/crowd.nix`

- `services/web-apps/atlassian/jira.nix`

- `services/web-apps/frab.nix`

- `services/web-apps/nixbot.nix`

- `services/web-apps/selfoss.nix`

- `services/web-apps/quassel-webserver.nix`

- `services/x11/unclutter-xfixes.nix`

- `services/x11/urxvtd.nix`

- `system/boot/systemd-nspawn.nix`

- `virtualisation/ecs-agent.nix`

- `virtualisation/lxcfs.nix`

- `virtualisation/openstack/keystone.nix`

- `virtualisation/openstack/glance.nix`

## Backward Incompatibilities {#sec-release-17.03-incompatibilities}

When upgrading from a previous release, please be aware of the following incompatible changes:

- Derivations have no `.nativeDrv` nor `.crossDrv` and are now cross by default, not native.

- `stdenv.overrides` is now expected to take `self` and `super` arguments. See `lib.trivial.extends` for what those parameters represent.

- `ansible` now defaults to ansible version 2 as version 1 has been removed due to a serious [ vulnerability](https://www.computest.nl/advisories/CT-2017-0109_Ansible.txt) unpatched by upstream.

- `gnome` alias has been removed along with `gtk`, `gtkmm` and several others. Now you need to use versioned attributes, like `gnome3`.

- The attribute name of the Radicale daemon has been changed from `pythonPackages.radicale` to `radicale`.

- The `stripHash` bash function in `stdenv` changed according to its documentation; it now outputs the stripped name to `stdout` instead of putting it in the variable `strippedName`.

- PHP now scans for extra configuration .ini files in /etc/php.d instead of /etc. This prevents accidentally loading non-PHP .ini files that may be in /etc.

- Two lone top-level dict dbs moved into `dictdDBs`. This affects: `dictdWordnet` which is now at `dictdDBs.wordnet` and `dictdWiktionary` which is now at `dictdDBs.wiktionary`

- Parsoid service now uses YAML configuration format. `service.parsoid.interwikis` is now called `service.parsoid.wikis` and is a list of either API URLs or attribute sets as specified in parsoid\'s documentation.

- `Ntpd` was replaced by `systemd-timesyncd` as the default service to synchronize system time with a remote NTP server. The old behavior can be restored by setting `services.ntp.enable` to `true`. Upstream time servers for all NTP implementations are now configured using `networking.timeServers`.

- `service.nylon` is now declared using named instances. As an example:

  ```nix
  {
    services.nylon = {
      enable = true;
      acceptInterface = "br0";
      bindInterface = "tun1";
      port = 5912;
    };
  }
  ```

  should be replaced with:

  ```nix
  {
    services.nylon.myvpn = {
      enable = true;
      acceptInterface = "br0";
      bindInterface = "tun1";
      port = 5912;
    };
  }
  ```

  this enables you to declare a SOCKS proxy for each uplink.

- `overridePackages` function no longer exists. It is replaced by [ overlays](https://nixos.org/nixpkgs/manual/#sec-overlays-install). For example, the following code:

  ```nix
  let
    pkgs = import <nixpkgs> {};
  in
    pkgs.overridePackages (self: super: ...)
  ```

  should be replaced by:

  ```nix
  let
    pkgs = import <nixpkgs> {};
  in
    import pkgs.path { overlays = [(self: super: ...)]; }
  ```

- Autoloading connection tracking helpers is now disabled by default. This default was also changed in the Linux kernel and is considered insecure if not configured properly in your firewall. If you need connection tracking helpers (i.e. for active FTP) please enable `networking.firewall.autoLoadConntrackHelpers` and tune `networking.firewall.connectionTrackingModules` to suit your needs.

- `local_recipient_maps` is not set to empty value by Postfix service. It\'s an insecure default as stated by Postfix documentation. Those who want to retain this setting need to set it via `services.postfix.extraConfig`.

- Iputils no longer provide ping6 and traceroute6. The functionality of these tools has been integrated into ping and traceroute respectively. To enforce an address family the new flags `-4` and `-6` have been added. One notable incompatibility is that specifying an interface (for link-local IPv6 for instance) is no longer done with the `-I` flag, but by encoding the interface into the address (`ping fe80::1%eth0`).

- The socket handling of the `services.rmilter` module has been fixed and refactored. As rmilter doesn\'t support binding to more than one socket, the options `bindUnixSockets` and `bindInetSockets` have been replaced by `services.rmilter.bindSocket.*`. The default is still a unix socket in `/run/rmilter/rmilter.sock`. Refer to the options documentation for more information.

- The `fetch*` functions no longer support md5, please use sha256 instead.

- The dnscrypt-proxy module interface has been streamlined around the `extraArgs` option. Where possible, legacy option declarations are mapped to `extraArgs` but will emit warnings. The `resolverList` has been outright removed: to use an unlisted resolver, use the `customResolver` option.

- torbrowser now stores local state under `~/.local/share/tor-browser` by default. Any browser profile data from the old location, `~/.torbrowser4`, must be migrated manually.

- The ihaskell, monetdb, offlineimap and sitecopy services have been removed.

## Other Notable Changes {#sec-release-17.03-notable-changes}

- Module type system have a new extensible option types feature that allow to extend certain types, such as enum, through multiple option declarations of the same option across multiple modules.

- `jre` now defaults to GTK UI by default. This improves visual consistency and makes Java follow system font style, improving the situation on HighDPI displays. This has a cost of increased closure size; for server and other headless workloads it\'s recommended to use `jre_headless`.

- Python 2.6 interpreter and package set have been removed.

- The Python 2.7 interpreter does not use modules anymore. Instead, all CPython interpreters now include the whole standard library except for \`tkinter\`, which is available in the Python package set.

- Python 2.7, 3.5 and 3.6 are now built deterministically and 3.4 mostly. Minor modifications had to be made to the interpreters in order to generate deterministic bytecode. This has security implications and is relevant for those using Python in a `nix-shell`. See the Nixpkgs manual for details.

- The Python package sets now use a fixed-point combinator and the sets are available as attributes of the interpreters.

- The Python function `buildPythonPackage` has been improved and can be used to build from Setuptools source, Flit source, and precompiled Wheels.

- When adding new or updating current Python libraries, the expressions should be put in separate files in `pkgs/development/python-modules` and called from `python-packages.nix`.

- The dnscrypt-proxy service supports synchronizing the list of public resolvers without working DNS resolution. This fixes issues caused by the resolver list becoming outdated. It also improves the viability of DNSCrypt only configurations.

- Containers using bridged networking no longer lose their connection after changes to the host networking.

- ZFS supports pool auto scrubbing.

- The bind DNS utilities (e.g. dig) have been split into their own output and are now also available in `pkgs.dnsutils` and it is no longer necessary to pull in all of `bind` to use them.

- Per-user configuration was moved from `~/.nixpkgs` to `~/.config/nixpkgs`. The former is still valid for `config.nix` for backwards compatibility.
