# Release 22.05 (“Quokka”, 2022.05/??) {#sec-release-22.05}

In addition to numerous new and upgraded packages, this release has the following highlights:

- Support is planned until the end of December 2022, handing over to 22.11.

## Highlights {#sec-release-22.05-highlights}

- `security.acme.defaults` has been added to simplify configuring
  settings for many certificates at once. This also opens up the
  the option to use DNS-01 validation when using `enableACME` on
  web server virtual hosts (e.g. `services.nginx.virtualHosts.*.enableACME`).

- PHP 8.1 is now available

- Mattermost has been updated to extended support release 6.3, as the previously packaged extended support release 5.37 is [reaching its end of life](https://docs.mattermost.com/upgrade/extended-support-release.html).
  Migrations may take a while, see the [changelog](https://docs.mattermost.com/install/self-managed-changelog.html#release-v6-3-extended-support-release)
  and [important upgrade notes](https://docs.mattermost.com/upgrade/important-upgrade-notes.html).

- systemd services can now set [systemd.services.\<name\>.reloadTriggers](#opt-systemd.services) instead of `reloadIfChanged` for a more granular distinction between reloads and restarts.

- [`kops`](https://kops.sigs.k8s.io) defaults to 1.22.4, which will enable [Instance Metadata Service Version 2](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-service.html) and require tokens on new clusters with Kubernetes 1.22. This will increase security by default, but may break some types of workloads. See the [release notes](https://kops.sigs.k8s.io/releases/1.22-notes/) for details.

## New Services {#sec-release-22.05-new-services}

- [aesmd](https://github.com/intel/linux-sgx#install-the-intelr-sgx-psw), the Intel SGX Architectural Enclave Service Manager. Available as [services.aesmd](#opt-services.aesmd.enable).

- [rootless Docker](https://docs.docker.com/engine/security/rootless/), a `systemd --user` Docker service which runs without root permissions. Available as [virtualisation.docker.rootless.enable](options.html#opt-virtualisation.docker.rootless.enable).

- [matrix-conduit](https://conduit.rs/), a simple, fast and reliable chat server powered by matrix. Available as [services.matrix-conduit](option.html#opt-services.matrix-conduit.enable).

- [filebeat](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-overview.html), a lightweight shipper for forwarding and centralizing log data. Available as [services.filebeat](#opt-services.filebeat.enable).

- [apfs](https://github.com/linux-apfs/linux-apfs-rw), a kernel module for mounting the Apple File System (APFS).

- [FRRouting](https://frrouting.org/), a popular suite of Internet routing protocol daemons (BGP, BFD, OSPF, IS-IS, VVRP and others). Available as [services.frr](#opt-services.frr.babel.enable)

- [heisenbridge](https://github.com/hifi/heisenbridge), a bouncer-style Matrix IRC bridge. Available as [services.heisenbridge](options.html#opt-services.heisenbridge.enable).

- [snowflake-proxy](https://snowflake.torproject.org/), a system to defeat internet censorship. Available as [services.snowflake-proxy](options.html#opt-services.snowflake-proxy.enable).

- [ergochat](https://ergo.chat), a modern IRC with IRCv3 features. Available as [services.ergochat](options.html#opt-services.ergochat.enable).

- [PowerDNS-Admin](https://github.com/ngoduykhanh/PowerDNS-Admin), a web interface for the PowerDNS server. Available at [services.powerdns-admin](options.html#opt-services.powerdns-admin.enable).

- [pgadmin4](https://github.com/postgres/pgadmin4), an admin interface for the PostgreSQL database. Available at [services.pgadmin](options.html#opt-services.pgadmin.enable).

- [input-remapper](https://github.com/sezanzeb/input-remapper), an easy to use tool to change the mapping of your input device buttons. Available at [services.input-remapper](options.html#opt-services.input-remapper.enable).

- [InvoicePlane](https://invoiceplane.com), web application for managing and creating invoices. Available at [services.invoiceplane](options.html#opt-services.invoiceplane.enable).

- [maddy](https://maddy.email), a composable all-in-one mail server. Available as [services.maddy](options.html#opt-services.maddy.enable).

- [K40-Whisperer](https://www.scorchworks.com/K40whisperer/k40whisperer.html), a program to control cheap Chinese laser cutters. Available as [programs.k40-whisperer.enable](options.html#opt-programs.k4-whisperer.enable). Users must add themselves to the `k40` group to be able to access the device.

- [mtr-exporter](https://github.com/mgumz/mtr-exporter), a Prometheus exporter for mtr metrics. Available as [services.mtr-exporter](options.html#opt-services.mtr-exporter.enable).

- [prometheus-pve-exporter](https://github.com/prometheus-pve/prometheus-pve-exporter), a tool that exposes information from the Proxmox VE API for use by Prometheus. Available as [services.prometheus.exporters.pve](options.html#opt-services.prometheus.exporters.pve).

- [tetrd](https://tetrd.app), share your internet connection from your device to your PC and vice versa through a USB cable. Available at [services.tetrd](#opt-services.tetrd.enable).

- [agate](https://github.com/mbrubeck/agate), a very simple server for the Gemini hypertext protocol. Available as [services.agate](options.html#opt-services.agate.enable).

- [ArchiSteamFarm](https://github.com/JustArchiNET/ArchiSteamFarm), a C# application with primary purpose of idling Steam cards from multiple accounts simultaneously. Available as [services.archisteamfarm](options.html#opt-services.archisteamfarm.enable).

- [teleport](https://goteleport.com), allows engineers and security professionals to unify access for SSH servers, Kubernetes clusters, web applications, and databases across all environments. Available at [services.teleport](#opt-services.teleport.enable).

- [BaGet](https://loic-sharma.github.io/BaGet/), a lightweight NuGet and symbol server. Available at [services.baget](#opt-services.baget.enable).

- [moosefs](https://moosefs.com), fault tolerant petabyte distributed file system.
  Available as [moosefs](#opt-services.moosefs.client.enable).

- [prosody-filer](https://github.com/ThomasLeister/prosody-filer), a server for handling XMPP HTTP Upload requests. Available at [services.prosody-filer](#opt-services.prosody-filer.enable).

- [systembus-notify](https://github.com/rfjakob/systembus-notify), allow system level notifications to reach the users. Available as [services.systembus-notify](opt-services.systembus-notify.enable). Please keep in mind that this service should only be enabled on machines with fully trusted users, as any local user is able to DoS user sessions by spamming notifications.

- [ethercalc](https://github.com/audreyt/ethercalc), an online collaborative
  spreadsheet. Available as [services.ethercalc](options.html#opt-services.ethercalc.enable).

- [nbd](https://nbd.sourceforge.io/), a Network Block Device server. Available as [services.nbd](options.html#opt-services.nbd.server.enable).

- [timetagger](https://timetagger.app), an open source time-tracker with an intuitive user experience and powerful reporting. [services.timetagger](options.html#opt-services.timetagger.enable).

- [rstudio-server](https://www.rstudio.com/products/rstudio/#rstudio-server), a browser-based version of the RStudio IDE for the R programming language. Available as [services.rstudio-server](options.html#opt-services.rstudio-server.enable).

- [headscale](https://github.com/juanfont/headscale), an Open Source implementation of the [Tailscale](https://tailscale.io) Control Server. Available as [services.headscale](options.html#opt-services.headscale.enable)

- [blocky](https://0xerr0r.github.io/blocky/), fast and lightweight DNS proxy as ad-blocker for local network with many features.

- [pacemaker](https://clusterlabs.org/pacemaker/) cluster resource manager

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

## Backward Incompatibilities {#sec-release-22.05-incompatibilities}

- `pkgs.ghc` now refers to `pkgs.targetPackages.haskellPackages.ghc`.
  This _only_ makes a difference if you are cross-compiling and will
  ensure that `pkgs.ghc` always runs on the host platform and compiles
  for the target platform (similar to `pkgs.gcc` for example).
  `haskellPackages.ghc` still behaves as before, running on the build
  platform and compiling for the host platform (similar to `stdenv.cc`).
  This means you don't have to adjust your derivations if you use
  `haskellPackages.callPackage`, but when using `pkgs.callPackage` and
  taking `ghc` as an input, you should now use `buildPackages.ghc`
  instead to ensure cross compilation keeps working (or switch to
  `haskellPackages.callPackage`).

- `pkgs.ghc.withPackages` as well as `haskellPackages.ghcWithPackages` etc.
  now needs be overridden directly, as opposed to overriding the result of
  calling it. Additionally, the `withLLVM` parameter has been renamed to
  `useLLVM`. So instead of `(ghc.withPackages (p: [])).override { withLLVM = true; }`,
  one needs to use `(ghc.withPackages.override { useLLVM = true; }) (p: [])`.

- The `home-assistant` module now requires users that don't want their
  configuration to be managed declaratively to set
  `services.home-assistant.config = null;`. This is required
  due to the way default settings are handled with the new settings style.

  Additionally the default list of `extraComponents` now includes the minimal
  dependencies to successfully complete the [onboarding](https://www.home-assistant.io/getting-started/onboarding/)
  procedure.

- `pkgs.emacsPackages.orgPackages` is removed because org elpa is deprecated.
  The packages in the top level of `pkgs.emacsPackages`, such as org and
  org-contrib, refer to the ones in `pkgs.emacsPackages.elpaPackages` and
  `pkgs.emacsPackages.nongnuPackages` where the new versions will release.

- `services.kubernetes.addons.dashboard` was removed due to it being an outdated version.

- `services.kubernetes.scheduler.{port,address}` now set `--secure-port` and `--bind-address` instead of `--port` and `--address`, since the former have been deprecated and are no longer functional in kubernetes>=1.23. Ensure that you are not relying on the insecure behaviour before upgrading.

- `services.k3s.enable` no longer implies `systemd.enableUnifiedCgroupHierarchy = false`, and will default to the 'systemd' cgroup driver when using `services.k3s.docker = true`.
  This change may require a reboot to take effect, and k3s may not be able to run if the boot cgroup hierarchy does not match its configuration.
  The previous behavior may be retained by explicitly setting `systemd.enableUnifiedCgroupHierarchy = false` in your configuration.

- `fonts.fonts` no longer includes ancient bitmap fonts when both `config.services.xserver.enable` and `config.nixpkgs.config.allowUnfree` are enabled.
  If you still want these fonts, use:

  ```nix
  {
    fonts.fonts = [
      pkgs.xorg.fontbhlucidatypewriter100dpi
      pkgs.xorg.fontbhlucidatypewriter75dpi
      pkgs.xorg.fontbh100dpi
    ];
  }
  ```

- The DHCP server (`services.dhcpd4`, `services.dhcpd6`) has been hardened.
  The service is now using the systemd's `DynamicUser` mechanism to run as an unprivileged dynamically-allocated user with limited capabilities.
  The dhcpd state files are now always stored in `/var/lib/dhcpd{4,6}` and the `services.dhcpd4.stateDir` and `service.dhcpd6.stateDir` options have been removed.
  If you were depending on root privileges or set{uid,gid,cap} binaries in dhcpd shell hooks, you may give dhcpd more capabilities with e.g. `systemd.services.dhcpd6.serviceConfig.AmbientCapabilities`.

- The `mailpile` email webclient (`services.mailpile`) has been removed due to its reliance on python2.

- The `matrix-synapse` service (`services.matrix-synapse`) has been converted to use the `settings` option defined in RFC42.
  This means that options that are part of your `homeserver.yaml` configuration, and that were specified at the top-level of the
  module (`services.matrix-synapse`) now need to be moved into `services.matrix-synapse.settings`. And while not all options you
  may use are defined in there, they are still supported, because you can set arbitrary values in this freeform type.

  An example to make the required migration clearer:

  Before:
  ```nix
  {
    services.matrix-synapse = {
      enable = true;

      server_name = "example.com";
      public_baseurl = "https://example.com:8448";

      enable_registration = false;
      registration_shared_secret = "xohshaeyui8jic7uutuDogahkee3aehuaf6ei3Xouz4iicie5thie6nohNahceut";
      macaroon_secret_key = "xoo8eder9seivukaiPh1cheikohquuw8Yooreid0The4aifahth3Ou0aiShaiz4l";

      tls_certificate_path = "/var/lib/acme/example.com/fullchain.pem";
      tls_certificate_path = "/var/lib/acme/example.com/fullchain.pem";

      listeners = [ {
        port = 8448;
        bind_address = "";
        type = "http";
        tls = true;
        resources = [ {
          names = [ "client" ];
          compress = true;
        } {
          names = [ "federation" ];
          compress = false;
        } ];
      } ];

    };
  }
  ```

  After:
  ```nix
  {
    services.matrix-synapse = {
      enable = true;

      # this attribute set holds all values that go into your homeserver.yaml configuration
      # See https://github.com/matrix-org/synapse/blob/develop/docs/sample_config.yaml for
      # possible values.
      settings = {
        server_name = "example.com";
        public_baseurl = "https://example.com:8448";

        enable_registration = false;
        # pass `registration_shared_secret` and `macaroon_secret_key` via `extraConfigFiles` instead

        tls_certificate_path = "/var/lib/acme/example.com/fullchain.pem";
        tls_certificate_path = "/var/lib/acme/example.com/fullchain.pem";

        listeners = [ {
          port = 8448;
          bind_address = [
            "::"
            "0.0.0.0"
          ];
          type = "http";
          tls = true;
          resources = [ {
            names = [ "client" ];
            compress = true;
          } {
            names = [ "federation" ];
            compress = false;
          } ];
        } ];
      };

      extraConfigFiles = [
        /run/keys/matrix-synapse/secrets.yaml
      ];
    };
  }
  ```

  The secrets in your original config should be migrated into a YAML file that is included via `extraConfigFiles`.

  Additionally a few option defaults have been synced up with upstream default values, for example the `max_upload_size` grew from `10M` to `50M`.

- The MoinMoin wiki engine (`services.moinmoin`) has been removed, because Python 2 is being retired from nixpkgs.

- Services in the `hadoop` module previously set `openFirewall` to true by default.
  This has now been changed to false. Node definitions for multi-node clusters would need
  `openFirewall = true;` to be added to to hadoop services when upgrading from NixOS 21.11.

- `services.hadoop.yarn.nodemanager` now uses cgroup-based CPU limit enforcement by default.
  Additionally, the option `useCGroups` was added to nodemanagers as an easy way to switch
  back to the old behavior.

- The `wafHook` hook now honors `NIX_BUILD_CORES` when `enableParallelBuilding` is not set explicitly. Packages can restore the old behaviour by setting `enableParallelBuilding=false`.

- `pkgs.claws-mail-gtk2`, representing Claws Mail's older release version three, was removed in order to get rid of Python 2.
  Please switch to `claws-mail`, which is Claws Mail's latest release based on GTK+3 and Python 3.

- The `writers.writePython2` and corresponding `writers.writePython2Bin` convenience functions to create executable Python 2 scripts in the store were removed in preparation of removal of the Python 2 interpreter.
  Scripts have to be converted to Python 3 for use with `writers.writePython3` or `writers.writePyPy2` needs to be used.

- `buildGoModule` was updated to use `go_1_17`, third party derivations that specify >= go 1.17 in the main `go.mod` will need to regenerate their `vendorSha256` hash.

- The `gnome-passwordsafe` package updated to [version 6.x](https://gitlab.gnome.org/World/secrets/-/tags/6.0) and renamed to `gnome-secrets`.

- If you previously used `/etc/docker/daemon.json`, you need to incorporate the changes into the new option `virtualisation.docker.daemon.settings`.

- Ntopng (`services.ntopng`) is updated to 5.2.1 and uses a separate Redis instance if `system.stateVersion` is at least `22.05`. Existing setups shouldn't be affected.

- The backward compatibility in `services.wordpress` to configure sites with
  the old interface has been removed. Please use `services.wordpress.sites`
  instead.

- The backward compatibility in `services.dokuwiki` to configure sites with the
  old interface has been removed. Please use `services.dokuwiki.sites` instead.

- opensmtpd-extras is no longer build with python2 scripting support due to python2 deprecation in nixpkgs

- `services.miniflux.adminCredentialFiles` is now required, instead of defaulting to `admin` and `password`.

- The `autorestic` package has been upgraded from 1.3.0 to 1.5.0 which introduces breaking changes in config file, check [their migration guide](https://autorestic.vercel.app/migration/1.4_1.5) for more details.

- For `pkgs.python3.pkgs.ipython`, its direct dependency `pkgs.python3.pkgs.matplotlib-inline`
  (which is really an adapter to integrate matplotlib in ipython if it is installed) does
  not depend on `pkgs.python3.pkgs.matplotlib` anymore.
  This is closer to a non-Nix install of ipython.
  This has the added benefit to reduce the closure size of `ipython` from ~400MB to ~160MB
  (including ~100MB for python itself).

- `documentation.man` has been refactored to support choosing a man implementation other than GNU's `man-db`. For this, `documentation.man.manualPages` has been renamed to `documentation.man.man-db.manualPages`. If you want to use the new alternative man implementation `mandoc`, add `documentation.man = { enable = true; man-db.enable = false; mandoc.enable = true; }` to your configuration.

- Normal users (with `isNormalUser = true`) which have non-empty `subUidRanges` or `subGidRanges` set no longer have additional implicit ranges allocated. To enable automatic allocation back set `autoSubUidGidRange = true`.

- `idris2` now requires `--package` when using packages `contrib` and `network`, while previously these idris2 packages were automatically loaded.

- The iputils package, which is installed by default, no longer provides the
  legacy tools `tftpd` and `traceroute6`. More tools (`ninfod`, `rarpd`, and
  `rdisc`) are going to be removed in the next release. See
  [upstream's release notes](https://github.com/iputils/iputils/releases/tag/20211215)
  for more details and available replacements.

- `services.thelounge.private` was removed in favor of `services.thelounge.public`, to follow with upstream changes.

- `pkgs.docbookrx` was removed since it's unmaintained

- `pkgs._7zz` is now correctly licensed as LGPL3+ and BSD3 with optional unfree unRAR licensed code

- `tilp2` was removed together with its module

- The F-PROT antivirus (`fprot` package) and its service module were removed because it
  reached [end-of-life](https://kb.cyren.com/av-support/index.php?/Knowledgebase/Article/View/434/0/end-of-sale--end-of-life-for-f-prot-and-csam).

- `bird1` and its modules `services.bird` as well as `services.bird6` have been removed. Upgrade to `services.bird2`.

- The options `networking.interfaces.<name>.ipv4.routes` and `networking.interfaces.<name>.ipv6.routes` are no longer ignored when using networkd instead of the default scripted network backend by setting `networking.useNetworkd` to `true`.

- MultiMC has been replaced with the fork PolyMC due to upstream developers being hostile to 3rd party package maintainers. PolyMC removes all MultiMC branding and is aimed at providing proper 3rd party packages like the one contained in Nixpkgs. This change affects the data folder where game instances and other save and configuration files are stored. Users with existing installations should rename `~/.local/share/multimc` to `~/.local/share/polymc`. The main config file's path has also moved from `~/.local/share/multimc/multimc.cfg` to `~/.local/share/polymc/polymc.cfg`.

- `systemd-nspawn@.service` settings have been reverted to the default systemd behaviour. User namespaces are now activated by default. If you want to keep running nspawn containers without user namespaces you need to set `systemd.nspawn.<name>.execConfig.PrivateUsers = false`

- The terraform 0.12 compatibility has been removed and the `terraform.withPlugins` and `terraform-providers.mkProvider` implementations simplified. Providers now need to be stored under
`$out/libexec/terraform-providers/<registry>/<owner>/<name>/<version>/<os>_<arch>/terraform-provider-<name>_v<version>` (which mkProvider does).

  This breaks back-compat so it's not possible to mix-and-match with previous versions of nixpkgs. In exchange, it now becomes possible to use the providers from [nixpkgs-terraform-providers-bin](https://github.com/numtide/nixpkgs-terraform-providers-bin) directly.

- The `dendrite` package has been upgraded from 0.5.1 to
  [0.6.5](https://github.com/matrix-org/dendrite/releases/tag/v0.6.5). Instances
  configured with split sqlite databases, which has been the default
  in NixOS, require merging of the federation sender and signing key
  databases. See upstream [release
  notes](https://github.com/matrix-org/dendrite/releases/tag/v0.6.0)
  on version 0.6.0 for details on database changes.

- The existing `pkgs.opentelemetry-collector` has been moved to
  `pkgs.opentelemetry-collector-contrib` to match the actual source being the
  "contrib" edition. `pkgs.opentelemetry-collector` is now the actual core
  release of opentelemetry-collector. If you use the community contributions
  you should change the package you refer to. If you don't need them update your
  commands from `otelcontribcol` to `otelcorecol` and enjoy a 7x smaller binary.

- `pkgs.pgadmin` now refers to `pkgs.pgadmin4`.
  If you still need pgadmin3, use `pkgs.pgadmin3`.

- `pkgs.noto-fonts-cjk` is now deprecated in favor of `pkgs.noto-fonts-cjk-sans`
  and `pkgs.noto-fonts-cjk-serif` because they each have different release
  schedules. To maintain compatibility with prior releases of Nixpkgs,
  `pkgs.noto-fonts-cjk` is currently an alias of `pkgs.noto-fonts-cjk-sans` and
  doesn't include serif fonts.

- `pkgs.epgstation` has been upgraded from v1 to v2, resulting in incompatible
  changes in the database scheme and configuration format.

- Some top-level settings under [services.epgstation](#opt-services.epgstation.enable)
  is now deprecated because it was redudant due to the same options being
  present in [services.epgstation.settings](#opt-services.epgstation.settings).

- The option `services.epgstation.basicAuth` was removed because basic
  authentication support was dropped by upstream.

- The option [services.epgstation.database.passwordFile](#opt-services.epgstation.database.passwordFile)
  no longer has a default value. Make sure to set this option explicitly before
  upgrading. Change the database password if necessary.

- The [services.epgstation.settings](#opt-services.epgstation.settings)
  option now expects options for `config.yml` in EPGStation v2.

- Existing data for the [services.epgstation](#opt-services.epgstation.enable)
  module would have to be backed up prior to the upgrade. To back up exising
  data to `/tmp/epgstation.bak`, run
  `sudo -u epgstation epgstation run backup /tmp/epgstation.bak`.
  To import that data after to the upgrade, run
  `sudo -u epgstation epgstation run v1migrate /tmp/epgstation.bak`

- `switch-to-configuration` (the script that is run when running `nixos-rebuild switch` for example) has been reworked
    * The interface that allows activation scripts to restart units has been streamlined. Restarting and reloading is now done by a single file `/run/nixos/activation-restart-list` that honors `restartIfChanged` and `reloadIfChanged` of the units.
        * Preferring to reload instead of restarting can still be achieved using `/run/nixos/activation-reload-list`.
    * The script now uses a proper ini-file parser to parse systemd units. Some values are now only searched in one section instead of in the entire unit. This is only relevant for units that don't use the NixOS systemd moule.
        * `RefuseManualStop`, `X-OnlyManualStart`, `X-StopOnRemoval`, `X-StopOnReconfiguration` are only searched in the `[Unit]` section
        * `X-ReloadIfChanged`, `X-RestartIfChanged`, `X-StopIfChanged` are only searched in the `[Service]` section

- The `services.bookstack.cacheDir` option has been removed, since the
  cache directory is now handled by systemd.

- The `services.bookstack.extraConfig` option has been replaced by
  `services.bookstack.config` which implements a
  [settings-style](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md)
  configuration.

- `lib.assertMsg` and `lib.assertOneOf` no longer return `false` if the passed condition is `false`, `throw`ing the given error message instead (which makes the resulting error message less cluttered). This will not impact the behaviour of code using these functions as intended, namely as top-level wrapper for `assert` conditions.

- The `vpnc` package has been changed to use GnuTLS instead of OpenSSL by default for licensing reasons.

- `pkgs.vimPlugins.onedark-nvim` now refers to [navarasu/onedark.nvim](https://github.com/navarasu/onedark.nvim)
  (formerly refers to [olimorris/onedarkpro.nvim](https://github.com/olimorris/onedarkpro.nvim)).

- `services.pipewire.enable` will default to enabling the WirePlumber session manager instead of pipewire-media-session.
  pipewire-media-session is deprecated by upstream and not recommended, but can still be manually enabled by setting
  `services.pipewire.media-session.enable` to `true` and `services.pipewire.wireplumber.enable` to `false`.

- `pkgs.makeDesktopItem` has been refactored to provide a more idiomatic API. Specifically:
  - All valid options as of FDO Desktop Entry specification version 1.4 can now be passed in as explicit arguments
  - `exec` can now be null, for entries that are not of type Application
  - `mimeType` argument is renamed to `mimeTypes` for consistency
  - `mimeTypes`, `categories`, `implements`, `keywords`, `onlyShowIn` and `notShowIn` take lists of strings instead of one string with semicolon separators
  - `extraDesktopEntries` renamed to `extraConfig` for consistency
  - Actions should now be provided as an attrset `actions`, the `Actions` line will be autogenerated.
  - `extraEntries` is removed.
  - Additional validation is added both at eval time and at build time.

  See the `vscode` package for a more detailed example.

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

## Other Notable Changes {#sec-release-22.05-notable-changes}

- The option [services.redis.servers](#opt-services.redis.servers) was added
  to support per-application `redis-server` which is more secure since Redis databases
  are only mere key prefixes without any configuration or ACL of their own.
  Backward-compatibility is preserved by mapping old `services.redis.settings`
  to `services.redis.servers."".settings`, but you are strongly encouraged
  to name each `redis-server` instance after the application using it,
  instead of keeping that nameless one.
  Except for the nameless `services.redis.servers.""`
  still accessible at `127.0.0.1:6379`,
  and to the members of the Unix group `redis`
  through the Unix socket `/run/redis/redis.sock`,
  all other `services.redis.servers.${serverName}`
  are only accessible by default
  to the members of the Unix group `redis-${serverName}`
  through the Unix socket `/run/redis-${serverName}/redis.sock`.

- The option [virtualisation.vmVariant](#opt-virtualisation.vmVariant) was added
  to allow users to make changes to the `nixos-rebuild build-vm` configuration
  that do not apply to their normal system.

  The `config.system.build.vm` attribute now always exists and defaults to the
  value from `vmVariant`. Configurations that import the `virtualisation/qemu-vm.nix`
  module themselves will override this value, such that `vmVariant` is not used.

  Similarly [virtualisation.vmVariantWithBootloader](#opt-virtualisation.vmVariantWithBootLoader) was added.

- The configuration portion of the `nix-daemon` module has been reworked and exposed as [nix.settings](options.html#opt-nix-settings):
  * Legacy options have been mapped to the corresponding options under under [nix.settings](options.html#opt-nix.settings) but may be deprecated in the future.
  * [nix.buildMachines.publicHostKey](options.html#opt-nix.buildMachines.publicHostKey) has been added.

- The `writers.writePyPy2`/`writers.writePyPy3` and corresponding `writers.writePyPy2Bin`/`writers.writePyPy3Bin` convenience functions to create executable Python 2/3 scripts using the PyPy interpreter were added.

- Some improvements have been made to the `hadoop` module:
  - A `gatewayRole` option has been added, for deploying hadoop cluster configuration files to a node that does not have any active services
  - Support for older versions of hadoop have been added to the module
  - Overriding and extending site XML files has been made easier

- If you are using Wayland you can choose to use the Ozone Wayland support
  in Chrome and several Electron apps by setting the environment variable
  `NIXOS_OZONE_WL=1` (for example via
  `environment.sessionVariables.NIXOS_OZONE_WL = "1"`).
  This is not enabled by default because Ozone Wayland is
  still under heavy development and behavior is not always flawless.
  Furthermore, not all Electron apps use the latest Electron versions.

- The `influxdb2` package was split into `influxdb2-server` and
  `influxdb2-cli`, matching the split that took place upstream. A
  combined `influxdb2` package is still provided in this release for
  backwards compatibilty, but will be removed at a later date.

- The `unifi` package was switched from `unifi6` to `unifi7`.
  Direct downgrades from Unifi 7 to Unifi 6 are not possible and require restoring from a backup made by Unifi 6.

- `programs.zsh.autosuggestions.strategy` now takes a list of strings instead of a string.

- The `services.unifi.openPorts` option default value of `true` is now deprecated and will be changed to `false` in 22.11.
  Configurations using this default will print a warning when rebuilt.

- `security.acme` certificates will now correctly check for CA
  revokation before reaching their minimum age.

- Removing domains from `security.acme.certs._name_.extraDomainNames`
  will now correctly remove those domains during rebuild/renew.

- MariaDB is now offered in several versions, not just the newest one.
  So if you have a need for running MariaDB 10.4 for example, you can now just set `services.mysql.package = pkgs.mariadb_104;`.
  In general, it is recommended to run the newest version, to get the newest features, while sticking with an LTS version will most likely provide a more stable experience.
  Sometimes software is also incompatible with the newest version of MariaDB.

- The option
  [programs.ssh.enableAskPassword](#opt-programs.ssh.enableAskPassword) was
  added, decoupling the setting of `SSH_ASKPASS` from
  `services.xserver.enable`. This allows easy usage in non-X11 environments,
  e.g. Wayland.

- [programs.ssh.knownHosts](#opt-programs.ssh.knownHosts) has gained an `extraHostNames`
  option to replace `hostNames`. `hostNames` is deprecated, but still available for now.

- The `services.stubby` module was converted to a [settings-style](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md) configuration.

- The option `services.duplicati.dataDir` has been added to allow changing the location of duplicati's files.

- The options `boot.extraModprobeConfig` and `boot.blacklistedKernelModules` now also take effect in the initrd by copying the file `/etc/modprobe.d/nixos.conf` into the initrd.

- `nixos-generate-config` now puts the dhcp configuration in `hardware-configuration.nix` instead of `configuration.nix`.

- ORY Kratos was updated to version 0.8.3-alpha.1.pre.0, which introduces some breaking changes:
  - If you are relying on the SQLite images, update your Docker Pull commands as follows:
    - `docker pull oryd/kratos:{version}`
  - Additionally, all passwords now have to be at least 8 characters long.
  - For more details, see:
    - [Release Notes for v0.8.1-alpha-1](https://github.com/ory/kratos/releases/tag/v0.8.1-alpha.1)
    - [Release Notes for v0.8.2-alpha-1](https://github.com/ory/kratos/releases/tag/v0.8.2-alpha.1)

- `fetchFromSourcehut` now allows fetching repositories recursively
  using `fetchgit` or `fetchhg` if the argument `fetchSubmodules`
  is set to `true`.

- The `element-desktop` package now has an `useKeytar` option (defaults to `true`),
  which allows disabling `keytar` and in turn `libsecret` usage
  (which binds to native credential managers / keychain libraries).

- The option `services.thelounge.plugins` has been added to allow installing plugins for The Lounge. Plugins can be found in `pkgs.theLoungePlugins.plugins` and `pkgs.theLoungePlugins.themes`.

- The option `services.xserver.videoDriver = [ "nvidia" ];` will now also install [nvidia VA-API drivers](https://github.com/elFarto/nvidia-vaapi-driver) by default.

- The `firmwareLinuxNonfree` package has been renamed to `linux-firmware`.

- It is now possible to specify wordlists to include as handy to access environment variables using the `config.environment.wordlist` configuration options.

- The `services.mbpfan` module was converted to a [RFC 0042](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md) configuration.

- The default value for `programs.spacefm.settings.graphical_su` got unset. It previously pointed to `gksu` which has been removed.

- A new module was added for the [Starship](https://starship.rs/) shell prompt,
  providing the options `programs.starship.enable` and `programs.starship.settings`.

- The [Dino](https://dino.im) XMPP client was updated to 0.3, adding support for audio and video calls.

- `services.mattermost.plugins` has been added to allow the declarative installation of Mattermost plugins.
  Plugins are automatically repackaged using autoPatchelf.

- `services.logrotate.enable` now defaults to true if any rotate path has
  been defined, and some paths have been added by default.

- The `zrepl` package has been updated from 0.4.0 to 0.5:

  - The RPC protocol version was bumped; all zrepl daemons in a setup must be updated and restarted before replication can resume.
  - A bug involving encrypt-on-receive has been fixed. Read the [zrepl documentation](https://zrepl.github.io/configuration/sendrecvoptions.html#job-recv-options-placeholder) and check the output of `zfs get -r encryption,zrepl:placeholder PATH_TO_ROOTFS` on the receiver.

- Renamed option `services.openssh.challengeResponseAuthentication` to `services.openssh.kbdInteractiveAuthentication`.
  Reason is that the old name has been deprecated upstream.
  Using the old option name will still work, but produce a warning.

- The `pomerium-cli` command has been moved out of the `pomerium` package into
  the `pomerium-cli` package, following upstream's repository split. If you are
  using the `pomerium-cli` command, you should now install the `pomerium-cli`
  package.

- The option
  [services.networking.networkmanager.enableFccUnlock](#opt-networking.networkmanager.enableFccUnlock)
  was added to support FCC unlock procedures. Since release 1.18.4, the ModemManager
  daemon no longer automatically performs the FCC unlock procedure by default. See
  [the docs](https://modemmanager.org/docs/modemmanager/fcc-unlock/) for more details.

- `programs.tmux` has a new option `plugins` that accepts a list of packages from the `tmuxPlugins` group. The specified packages are added to the system and loaded by `tmux`.

- The polkit service, available at `security.polkit.enable`, is now disabled by default. It will automatically be enabled through services and desktop environments as needed.

- The `hadoop` package has added support for `aarch64-linux` and `aarch64-darwin` as of 3.3.1 ([#158613](https://github.com/NixOS/nixpkgs/pull/158613)).

- The `R` package now builds again on `aarch64-darwin` ([#158992](https://github.com/NixOS/nixpkgs/pull/158992)).

- The `spark3` package has been updated from 3.1.2 to 3.2.1 ([#160075](https://github.com/NixOS/nixpkgs/pull/160075)):

  - Testing has been enabled for `aarch64-linux` in addition to `x86_64-linux`.
  - The `spark3` package is now usable on `aarch64-darwin` as a result of [#158613](https://github.com/NixOS/nixpkgs/pull/158613) and [#158992](https://github.com/NixOS/nixpkgs/pull/158992).

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->
