{ lib, stdenv, fetchFromGitHub, sass, glib, libxml2, gdk-pixbuf
, gtk-engine-murrine
}:

stdenv.mkDerivation rec {
  version = "2.6.7";
  pname = "numix-gtk-theme";

  src = fetchFromGitHub {
    repo = "numix-gtk-theme";
    owner = "numixproject";
    rev = version;
    sha256 = "12mw0kr0kkvg395qlbsvkvaqccr90cmxw5rrsl236zh43kj8grb7";
  };

  nativeBuildInputs = [ sass glib libxml2 gdk-pixbuf ];

  propagatedUserEnvPkgs = [ gtk-engine-murrine ];

  postPatch = ''
    substituteInPlace Makefile --replace '$(DESTDIR)'/usr $out
    patchShebangs .
  '';

  meta = {
    description = "Modern flat theme with a combination of light and dark elements (GNOME, Unity, Xfce and Openbox)";
    homepage = "https://numixproject.github.io";
    license = lib.licenses.gpl3Plus;
    platforms = lib.platforms.all;
    maintainers = [ lib.maintainers.romildo ];
  };
}
