{lib, stdenv, fetchurl}:

stdenv.mkDerivation rec {
  pname = "STLport";
  version = "5.2.1";

  src = fetchurl {
    url = "mirror://sourceforge/stlport/${pname}-${version}.tar.bz2";
    sha256 = "1jbgak1m1qk7d4gyn1p2grbws2icsf7grbs3dh44ai9ck1xh0nvm";
  };

  # fix hardcoded /usr/bin; not recognizing the standard --disable-static flag
  configurePhase = ''
    echo Preconf: build/Makefiles/gmake/*/sys.mak
    for f in build/Makefiles/gmake/*/sys.mak; do
      substituteInPlace "$f" --replace /usr/bin/ ""
    done
    ./configure --prefix=$out
  '';

  meta = {
    description = "An implementation of the C++ Standard Library";
    homepage = "https://sourceforge.net/projects/stlport/";
    license = lib.licenses.free; # seems BSD-like
    broken = true; # probably glibc-2.20 -related issue
  };
}
