#!/nix/store/4nmqxajzaf60yjribkgvj5j54x9yvr1r-bash-5.1-p12/bin/bash
set -eu
# if the pstore module is builtin it will have mounted the persistent store automatically. it may also be already mounted for other reasons.
/nix/store/jwqzf74yfhwcg4h4mdwdg2qf881jzdi8-util-linux-2.37.3-bin/bin/mountpoint -q /sys/fs/pstore || /nix/store/jwqzf74yfhwcg4h4mdwdg2qf881jzdi8-util-linux-2.37.3-bin/bin/mount -t pstore -o nosuid,noexec,nodev pstore /sys/fs/pstore
# wait up to 1.5 seconds for the backend to be registered and the files to appear. a systemd path unit cannot detect this happening; and succeeding after a restart would not start dependent units.
TRIES=15
while [ "$(cat /sys/module/pstore/parameters/backend)" = "(null)" ]; do
  if (( $TRIES )); then
    sleep 0.1
    TRIES=$((TRIES-1))
  else
    echo "Persistent Storage backend was not registered in time." >&2
    break
  fi
done

