# Release 21.11 (“Porcupine”, 2021/11/30) {#sec-release-21.11}

- Support is planned until the end of June 2022, handing over to 22.05.

## Highlights {#sec-release-21.11-highlights}

In addition to numerous new and upgraded packages, this release has the following highlights:

- Nix has been updated to version 2.4, reference its [release notes](https://discourse.nixos.org/t/nix-2-4-released/15822) for more information on what has changed. The previous version of Nix, 2.3.16, remains available for the time being in the `nix_2_3` package.

- `iptables` now uses `nf_tables` backend.

- PHP now defaults to PHP 8.0, updated from 7.4.

- kops now defaults to 1.21.1, which uses containerd as the default runtime.

- `python3` now defaults to Python 3.9, updated from Python 3.8.

- PostgreSQL now defaults to major version 13.

- spark now defaults to spark 3, updated from 2. A [migration guide](https://spark.apache.org/docs/latest/core-migration-guide.html#upgrading-from-core-24-to-30) is available.

- Improvements have been made to the Hadoop module and package:
  - HDFS and YARN now support production-ready highly available deployments with automatic failover.
  - Hadoop now defaults to Hadoop 3, updated from 2.
  - JournalNode, ZKFS and HTTPFS services have been added.

- Activation scripts can now, optionally, be run during a `nixos-rebuild dry-activate` and can detect the dry activation by reading `$NIXOS_ACTION`.
  This allows activation scripts to output what they would change if the activation was really run.
  The users/modules activation script supports this and outputs some of is actions.

- KDE Plasma now finally works on Wayland.

- bash now defaults to major version 5.

- Systemd was updated to version 249 (from 247).

- Pantheon desktop has been updated to version 6. Due to changes of screen locker, if locking doesn't work for you, please try `gsettings set org.gnome.desktop.lockdown disable-lock-screen false`.

- `kubernetes-helm` now defaults to 3.7.0, which introduced some breaking changes to the experimental OCI manifest format. See [HIP 6](https://github.com/helm/community/blob/main/hips/hip-0006.md) for more details.
  `helmfile` also defaults to 0.141.0, which is the minimum compatible version.

- GNOME has been upgraded to 41. Please take a look at their [Release Notes](https://help.gnome.org/misc/release-notes/41.0/) for details.

- LXD support was greatly improved:
  - building LXD images from configurations is now directly possible with just nixpkgs
  - hydra is now building nixOS LXD images that can be used standalone with full nixos-rebuild support

- OpenSSH was updated to version 8.8p1
  - This breaks connections to old SSH daemons as ssh-rsa host keys and ssh-rsa public keys that were signed with SHA-1 are disabled by default now
  - These can be re-enabled, see the [OpenSSH changelog](https://www.openssh.com/txt/release-8.8) for details

- ORY Kratos was updated to version 0.8.0-alpha.3
  - This release requires you to run SQL migrations. Please, as always, create a backup of your database first!
  - The SDKs are now generated with tag v0alpha2 to reflect that some signatures have changed in a breaking fashion. Please update your imports from v0alpha1 to v0alpha2.
  - The SMTPS scheme used in courier config URL with cleartext/StartTLS/TLS SMTP connection types is now only supporting implicit TLS. For StartTLS and cleartext SMTP, please use the SMTP scheme instead.
  - for more details, see [Release Notes](https://github.com/ory/kratos/releases/tag/v0.8.0-alpha.1).

## New Services {#sec-release-21.11-new-services}

- [btrbk](https://digint.ch/btrbk/index.html), a backup tool for btrfs subvolumes, taking advantage of btrfs specific capabilities to create atomic snapshots and transfer them incrementally to your backup locations. Available as [services.btrbk](options.html#opt-services.brtbk.instances).

- [clipcat](https://github.com/xrelkd/clipcat/), an X11 clipboard manager written in Rust. Available at [services.clipcat](options.html#opt-services.clipcat.enable).

- [dex](https://github.com/dexidp/dex), an OpenID Connect (OIDC) identity and OAuth 2.0 provider. Available at [services.dex](options.html#opt-services.dex.enable).

- [geoipupdate](https://github.com/maxmind/geoipupdate), a GeoIP database updater from MaxMind. Available as [services.geoipupdate](options.html#opt-services.geoipupdate.enable).

- [Jibri](https://github.com/jitsi/jibri), a service for recording or streaming a Jitsi Meet conference. Available as [services.jibri](options.html#opt-services.jibri.enable).

- [Kea](https://www.isc.org/kea/), ISCs 2nd generation DHCP and DDNS server suite. Available at [services.kea](options.html#opt-services.kea.dhcp4).

- [owncast](https://owncast.online/), self-hosted video live streaming solution. Available at [services.owncast](options.html#opt-services.owncast.enable).

- [PeerTube](https://joinpeertube.org/), developed by Framasoft, is the free and decentralized alternative to video platforms. Available at [services.peertube](options.html#opt-services.peertube.enable).

- [sourcehut](https://sr.ht), a collection of tools useful for software development. Available as [services.sourcehut](options.html#opt-services.sourcehut.enable).

- [ucarp](https://download.pureftpd.org/pub/ucarp/README), an userspace implementation of the Common Address Redundancy Protocol (CARP). Available as [networking.ucarp](options.html#opt-networking.ucarp.enable).

- Users of flashrom should migrate to [programs.flashrom.enable](options.html#opt-programs.flashrom.enable) and add themselves to the `flashrom` group to be able to access programmers supported by flashrom.

- [vikunja](https://vikunja.io), a to-do list app. Available as [services.vikunja](#opt-services.vikunja.enable).

- [opensnitch](https://github.com/evilsocket/opensnitch), an application firewall. Available as [services.opensnitch](#opt-services.opensnitch.enable).

- [snapraid](https://www.snapraid.it/), a backup program for disk arrays.
  Available as [snapraid](#opt-snapraid.enable).

- [Hockeypuck](https://github.com/hockeypuck/hockeypuck), a OpenPGP Key Server. Available as [services.hockeypuck](#opt-services.hockeypuck.enable).

- [buildkite-agent-metrics](https://github.com/buildkite/buildkite-agent-metrics), a command-line tool for collecting Buildkite agent metrics, now has a Prometheus exporter available as [services.prometheus.exporters.buildkite-agent](#opt-services.prometheus.exporters.buildkite-agent.enable).

- [influxdb-exporter](https://github.com/prometheus/influxdb_exporter) a Prometheus exporter that exports metrics received on an InfluxDB compatible endpoint is now available as [services.prometheus.exporters.influxdb](#opt-services.prometheus.exporters.influxdb.enable).

- [mx-puppet-discord](https://github.com/matrix-discord/mx-puppet-discord), a discord puppeting bridge for matrix. Available as [services.mx-puppet-discord](#opt-services.mx-puppet-discord.enable).

- [MeshCentral](https://www.meshcommander.com/meshcentral2/overview), a remote administration service ("TeamViewer but self-hosted and with more features") is now available with a package and a module: [services.meshcentral.enable](#opt-services.meshcentral.enable)

- [moonraker](https://github.com/Arksine/moonraker), an API web server for Klipper.
  Available as [moonraker](#opt-services.moonraker.enable).

- [influxdb2](https://github.com/influxdata/influxdb), a Scalable datastore for metrics, events, and real-time analytics. Available as [services.influxdb2](#opt-services.influxdb2.enable).

- [isso](https://posativ.org/isso/), a commenting server similar to Disqus.
  Available as [isso](#opt-services.isso.enable)

- [navidrome](https://www.navidrome.org/), a personal music streaming server with
  subsonic-compatible api. Available as [navidrome](#opt-services.navidrome.enable).

- [fluidd](https://docs.fluidd.xyz/), a Klipper web interface for managing 3d printers using moonraker. Available as [fluidd](#opt-services.fluidd.enable).

- [sx](https://github.com/earnestly/sx), a simple alternative to both xinit and startx for starting a Xorg server. Available as [services.xserver.displayManager.sx](#opt-services.xserver.displayManager.sx.enable)

- [postfixadmin](https://postfixadmin.sourceforge.io/), a web based virtual user administration interface for Postfix mail servers. Available as [postfixadmin](#opt-services.postfixadmin.enable).

- [prowlarr](https://wiki.servarr.com/prowlarr), an indexer manager/proxy built on the popular arr .net/reactjs base stack [services.prowlarr](#opt-services.prowlarr.enable).

- [soju](https://sr.ht/~emersion/soju), a user-friendly IRC bouncer. Available as [services.soju](options.html#opt-services.soju.enable).

- [nats](https://nats.io/), a high performance cloud and edge messaging system. Available as [services.nats](#opt-services.nats.enable).

- [git](https://git-scm.com), a distributed version control system. Available as [programs.git](options.html#opt-programs.git.enable).

- [parsedmarc](https://domainaware.github.io/parsedmarc/), a service
  which parses incoming [DMARC](https://dmarc.org/) reports and stores
  or sends them to a downstream service for further analysis.
  Documented in [its manual entry](#module-services-parsedmarc).

- [spark](https://spark.apache.org/), a unified analytics engine for large-scale data processing.

- [touchegg](https://github.com/JoseExposito/touchegg), a multi-touch gesture recognizer. Available as [services.touchegg](#opt-services.touchegg.enable).

- [pantheon-tweaks](https://github.com/pantheon-tweaks/pantheon-tweaks), an unofficial system settings panel for Pantheon. Available as [programs.pantheon-tweaks](#opt-programs.pantheon-tweaks.enable).

- [joycond](https://github.com/DanielOgorchock/joycond), a service that uses `hid-nintendo` to provide nintendo joycond pairing and better nintendo switch pro controller support.

- [multipath](https://github.com/opensvc/multipath-tools), the device mapper multipath (DM-MP) daemon. Available as [services.multipath](#opt-services.multipath.enable).

- [seafile](https://www.seafile.com/en/home/), an open source file syncing & sharing software. Available as [services.seafile](options.html#opt-services.seafile.enable).

- [rasdaemon](https://github.com/mchehab/rasdaemon), a hardware error logging daemon. Available as [hardware.rasdaemon](#opt-hardware.rasdaemon.enable).

- `code-server`-module now available

- [xmrig](https://github.com/xmrig/xmrig), a high performance, open source, cross platform RandomX, KawPow, CryptoNight and AstroBWT unified CPU/GPU miner and RandomX benchmark.

- Auto nice daemons [ananicy](https://github.com/Nefelim4ag/Ananicy) and [ananicy-cpp](https://gitlab.com/ananicy-cpp/ananicy-cpp/). Available as [services.ananicy](#opt-services.ananicy.enable).

- [smartctl_exporter](https://github.com/prometheus-community/smartctl_exporter), a Prometheus exporter for [S.M.A.R.T.](https://en.wikipedia.org/wiki/S.M.A.R.T.) data. Available as [services.prometheus.exporters.smartctl](options.html#opt-services.prometheus.exporters.smartctl.enable).

## Backward Incompatibilities {#sec-release-21.11-incompatibilities}

- The NixOS VM test framework, `pkgs.nixosTest`/`make-test-python.nix`, now requires detaching commands such as `succeed("foo &")` and `succeed("foo | xclip -i")` to close stdout.
  This can be done with a redirect such as `succeed("foo >&2 &")`. This breaking change was necessitated by a race condition causing tests to fail or hang.
  It applies to all methods that invoke commands on the nodes, including `execute`, `succeed`, `fail`, `wait_until_succeeds`, `wait_until_fails`.

- The `services.wakeonlan` option was removed, and replaced with `networking.interfaces.<name>.wakeOnLan`.

- The `security.wrappers` option now requires to always specify an owner, group and whether the setuid/setgid bit should be set.
  This is motivated by the fact that before NixOS 21.11, specifying either setuid or setgid but not owner/group resulted in wrappers owned by nobody/nogroup, which is unsafe.

- Since `iptables` now uses `nf_tables` backend and `ipset` doesn't support it, some applications (ferm, shorewall, firehol) may have limited functionality.

- The `paperless` module and package have been removed. All users should migrate to the
  successor `paperless-ng` instead. The Paperless project [has been
  archived](https://github.com/the-paperless-project/paperless/commit/9b0063c9731f7c5f65b1852cb8caff97f5e40ba4)
  and advises all users to use `paperless-ng` instead.

  Users can use the `services.paperless-ng` module as a replacement while noting the following incompatibilities:

  - `services.paperless.ocrLanguages` has no replacement. Users should migrate to [`services.paperless-ng.extraConfig`](options.html#opt-services.paperless-ng.extraConfig) instead:

  ```nix
  {
    services.paperless-ng.extraConfig = {
      # Provide languages as ISO 639-2 codes
      # separated by a plus (+) sign.
      # https://en.wikipedia.org/wiki/List_of_ISO_639-2_codes
      PAPERLESS_OCR_LANGUAGE = "deu+eng+jpn"; # German & English & Japanse
    };
  }
  ```

  - If you previously specified `PAPERLESS_CONSUME_MAIL_*` settings in
    `services.paperless.extraConfig` you should remove those options now. You
    now _must_ define those settings in the admin interface of paperless-ng.

  - Option `services.paperless.manage` no longer exists.
    Use the script at `${services.paperless-ng.dataDir}/paperless-ng-manage` instead.
    Note that this script only exists after the `paperless-ng` service has been
    started at least once.

  - After switching to the new system configuration you should run the Django
    management command to reindex your documents and optionally create a user,
    if you don't have one already.

    To do so, enter the data directory (the value of
    `services.paperless-ng.dataDir`, `/var/lib/paperless` by default), switch
    to the paperless user and execute the management command like below:

    ```
    $ cd /var/lib/paperless
    $ su paperless -s /bin/sh
    $ ./paperless-ng-manage document_index reindex
    # if not already done create a user account, paperless-ng requires a login
    $ ./paperless-ng-manage createsuperuser
    Username (leave blank to use 'paperless'): my-user-name
    Email address: me@example.com
    Password: **********
    Password (again): **********
    Superuser created successfully.
    ```

- The `staticjinja` package has been upgraded from 1.0.4 to 4.1.1

- Firefox v91 does not support addons with invalid signature anymore. Firefox ESR needs to be used for nix addon support.

- The `erigon` ethereum node has moved to a new database format in `2021-05-04`, and requires a full resync

- The `erigon` ethereum node has moved it's database location in `2021-08-03`, users upgrading must manually move their chaindata (see [release notes](https://github.com/ledgerwatch/erigon/releases/tag/v2021.08.03)).

- [users.users.&lt;name&gt;.group](options.html#opt-users.users._name_.group) no longer defaults to `nogroup`, which was insecure. Out-of-tree modules are likely to require adaptation: instead of
  ```nix
  {
    users.users.foo = {
      isSystemUser = true;
    };
  }
  ```
  also create a group for your user:
  ```nix
  {
    users.users.foo = {
      isSystemUser = true;
      group = "foo";
    };
    users.groups.foo = {};
  }
  ```

- `services.geoip-updater` was broken and has been replaced by [services.geoipupdate](options.html#opt-services.geoipupdate.enable).

- `ihatemoney` has been updated to version 5.1.1 ([release notes](https://github.com/spiral-project/ihatemoney/blob/5.1.1/CHANGELOG.rst)). If you serve ihatemoney by HTTP rather than HTTPS, you must set [services.ihatemoney.secureCookie](options.html#opt-services.ihatemoney.secureCookie) to `false`.

- PHP 7.3 is no longer supported due to upstream not supporting this version for the entire lifecycle of the 21.11 release.

- Those making use of `buildBazelPackage` will need to regenerate the fetch hashes (preferred), or set `fetchConfigured = false;`.

- `consul` was upgraded to a new major release with breaking changes, see [upstream changelog](https://github.com/hashicorp/consul/releases/tag/v1.10.0).

- fsharp41 has been removed in preference to use the latest dotnet-sdk

- The following F#-related packages have been removed for being unmaintaned. Please use `fetchNuGet` for specific packages.

  - ExtCore
  - Fake
  - Fantomas
  - FsCheck
  - FsCheck262
  - FsCheckNunit
  - FSharpAutoComplete
  - FSharpCompilerCodeDom
  - FSharpCompilerService
  - FSharpCompilerTools
  - FSharpCore302
  - FSharpCore3125
  - FSharpCore4001
  - FSharpCore4117
  - FSharpData
  - FSharpData225
  - FSharpDataSQLProvider
  - FSharpFormatting
  - FsLexYacc
  - FsLexYacc706
  - FsLexYaccRuntime
  - FsPickler
  - FsUnit
  - Projekt
  - Suave
  - UnionArgParser
  - ExcelDnaRegistration
  - MathNetNumerics

- `programs.x2goserver` is now `services.x2goserver`

- The following dotnet-related packages have been removed for being unmaintaned. Please use `fetchNuGet` for specific packages.
  - Autofac
  - SystemValueTuple
  - MicrosoftDiaSymReader
  - MicrosoftDiaSymReaderPortablePdb
  - SystemCollectionsImmutable
  - SystemCollectionsImmutable131
  - SystemReflectionMetadata
  - NUnit350
  - Deedle
  - ExcelDna
  - GitVersionTree
  - NDeskOptions

* The `antlr` package now defaults to the 4.x release instead of the
  old 2.7.7 version.

* The `pulseeffects` package updated to [version 4.x](https://github.com/wwmm/easyeffects/releases/tag/v6.0.0) and renamed to `easyeffects`.

* The `libwnck` package now defaults to the 3.x release instead of the
  old 2.31.0 version.

* The `bitwarden_rs` packages and modules were renamed to `vaultwarden`
  [following upstream](https://github.com/dani-garcia/vaultwarden/discussions/1642). More specifically,

  - `pkgs.bitwarden_rs`, `pkgs.bitwarden_rs-sqlite`, `pkgs.bitwarden_rs-mysql` and
    `pkgs.bitwarden_rs-postgresql` were renamed to `pkgs.vaultwarden`, `pkgs.vaultwarden-sqlite`,
    `pkgs.vaultwarden-mysql` and `pkgs.vaultwarden-postgresql`, respectively.

    - Old names are preserved as aliases for backwards compatibility, but may be removed in the future.
    - The `bitwarden_rs` executable was also renamed to `vaultwarden` in all packages.

  - `pkgs.bitwarden_rs-vault` was renamed to `pkgs.vaultwarden-vault`.

    - `pkgs.bitwarden_rs-vault` is preserved as an alias for backwards compatibility, but may be removed in the future.
    - The static files were moved from `/usr/share/bitwarden_rs` to `/usr/share/vaultwarden`.

  - The `services.bitwarden_rs` config module was renamed to `services.vaultwarden`.

    - `services.bitwarden_rs` is preserved as an alias for backwards compatibility, but may be removed in the future.

  - `systemd.services.bitwarden_rs`, `systemd.services.backup-bitwarden_rs` and `systemd.timers.backup-bitwarden_rs`
    were renamed to `systemd.services.vaultwarden`, `systemd.services.backup-vaultwarden` and
    `systemd.timers.backup-vaultwarden`, respectively.

    - Old names are preserved as aliases for backwards compatibility, but may be removed in the future.

  - `users.users.bitwarden_rs` and `users.groups.bitwarden_rs` were renamed to `users.users.vaultwarden` and
    `users.groups.vaultwarden`, respectively.

  - The data directory remains located at `/var/lib/bitwarden_rs`, for backwards compatibility.

- `yggdrasil` was upgraded to a new major release with breaking changes, see [upstream changelog](https://github.com/yggdrasil-network/yggdrasil-go/releases/tag/v0.4.0).

- `icingaweb2` was upgraded to a new release which requires a manual database upgrade, see [upstream changelog](https://github.com/Icinga/icingaweb2/releases/tag/v2.9.0).

- The `isabelle` package has been upgraded from 2020 to 2021

- the `mingw-64` package has been upgraded from 6.0.0 to 9.0.0

- `tt-rss` was upgraded to the commit on 2021-06-21, which has breaking changes. If you use `services.tt-rss.extraConfig` you should migrate to the `putenv`-style configuration. See [this Discourse post](https://community.tt-rss.org/t/rip-config-php-hello-classes-config-php/4337) in the tt-rss forums for more details.

- The following Visual Studio Code extensions were renamed to keep the naming convention uniform.

  - `bbenoist.Nix` -> `bbenoist.nix`
  - `CoenraadS.bracket-pair-colorizer` -> `coenraads.bracket-pair-colorizer`
  - `golang.Go` -> `golang.go`

- `services.uptimed` now uses `/var/lib/uptimed` as its stateDirectory instead of `/var/spool/uptimed`. Make sure to move all files to the new directory.

- Deprecated package aliases in `emacs.pkgs.*` have been removed. These aliases were remnants of the old Emacs package infrastructure. We now use exact upstream names wherever possible.

- `programs.neovim.runtime` switched to a `linkFarm` internally, making it impossible to use wildcards in the `source` argument.

- The `openrazer` and `openrazer-daemon` packages as well as the `hardware.openrazer` module now require users to be members of the `openrazer` group instead of `plugdev`. With this change, users no longer need be granted the entire set of `plugdev` group permissions, which can include permissions other than those required by `openrazer`. This is desirable from a security point of view. The setting [`harware.openrazer.users`](options.html#opt-services.hardware.openrazer.users) can be used to add users to the `openrazer` group.

- The fontconfig service's dpi option has been removed.
  Fontconfig should use Xft settings by default so there's no need to override one value in multiple places.
  The user can set DPI via ~/.Xresources properly, or at the system level per monitor, or as a last resort at the system level with `services.xserver.dpi`.

- The `yambar` package has been split into `yambar` and `yambar-wayland`, corresponding to the xorg and wayland backend respectively. Please switch to `yambar-wayland` if you are on wayland.

- The `services.minio` module gained an additional option `consoleAddress`, that
  configures the address and port the web UI is listening, it defaults to `:9001`.
  To be able to access the web UI this port needs to be opened in the firewall.

- The `varnish` package was upgraded from 6.3.x to 7.x. `varnish60` for the last LTS release is also still available.

- The `kubernetes` package was upgraded to 1.22. The `kubernetes.apiserver.kubeletHttps` option was removed and HTTPS is always used.

- The attribute `linuxPackages_latest_hardened` was dropped because the hardened patches
  lag behind the upstream kernel which made version bumps harder. If you want to use
  a hardened kernel, please pin it explicitly with a versioned attribute such as
  `linuxPackages_5_10_hardened`.

- The `nomad` package now defaults to a 1.1.x release instead of 1.0.x

- If `exfat` is included in `boot.supportedFilesystems` and when using kernel 5.7
  or later, the `exfatprogs` user-space utilities are used instead of `exfat`.

- The `todoman` package was upgraded from 3.9.0 to 4.0.0. This introduces breaking changes in the [configuration file](https://todoman.readthedocs.io/en/stable/configure.html#configuration-file) format.

- The `datadog-agent`, `datadog-integrations-core` and `datadog-process-agent` packages
  were upgraded from 6.11.2 to 7.30.2, git-2018-09-18 to 7.30.1 and 6.11.1 to 7.30.2,
  respectively. As a result `services.datadog-agent` has had breaking changes to the
  configuration file. For details, see the [upstream changelog](https://github.com/DataDog/datadog-agent/blob/main/CHANGELOG.rst).

- `opencv2` no longer includes the non-free libraries by default, and consequently `pfstools` no longer includes OpenCV support by default.  Both packages now support an `enableUnfree` option to re-enable this functionality.
- `services.xserver.displayManager.defaultSession = "plasma5"` does not work anymore, instead use either `"plasma"` for the Plasma X11 session or `"plasmawayland"` for the Plasma Wayland sesison.

- `boot.kernelParams` now only accepts one command line parameter per string. This change is aimed to reduce common mistakes like "param = 12", which would be parsed as 3 parameters.

- `nix.daemonNiceLevel` and `nix.daemonIONiceLevel` have been removed in favour of the new options [`nix.daemonCPUSchedPolicy`](options.html#opt-nix.daemonCPUSchedPolicy), [`nix.daemonIOSchedClass`](options.html#opt-nix.daemonIOSchedClass) and [`nix.daemonIOSchedPriority`](options.html#opt-nix.daemonIOSchedPriority). Please refer to the options documentation and the `sched(7)` and `ioprio_set(2)` man pages for guidance on how to use them.

- The `coursier` package's binary was renamed from `coursier` to `cs`. Completions which haven't worked for a while should now work with the renamed binary. To keep using `coursier`, you can create a shell alias.

- The `services.mosquitto` module has been rewritten to support multiple listeners and per-listener configuration.
  Module configurations from previous releases will no longer work and must be updated.

- The `fluidsynth_1` attribute has been removed, as this legacy version is no longer needed in nixpkgs. The actively maintained 2.x series is available as `fluidsynth` unchanged.

- Nextcloud 20 (`pkgs.nextcloud20`) has been dropped because it was EOLed by upstream in 2021-10.

- The `virtualisation.pathsInNixDB` option was renamed
  [`virtualisation.additionalPaths`](options.html#opt-virtualisation.additionalPaths).

- The `services.ddclient.password` option was removed, and replaced with `services.ddclient.passwordFile`.

- The default GNAT version has been changed: The `gnat` attribute now points to `gnat11`
  instead of `gnat9`.

- `retroArchCores` has been removed. This means that using `nixpkgs.config.retroarch` to customize RetroArch cores is not supported anymore. Instead, use package overrides, for example: `retroarch.override { cores = with libretro; [ citra snes9x ]; };`. Also, `retroarchFull` derivation is available for those who want to have all RetroArch cores available.

- The Linux kernel for security reasons now restricts access to BPF syscalls via `BPF_UNPRIV_DEFAULT_OFF=y`. Unprivileged access can be reenabled via the `kernel.unprivileged_bpf_disabled` sysctl knob.

## Other Notable Changes {#sec-release-21.11-notable-changes}


- The linux kernel package infrastructure was moved out of `all-packages.nix`, and restructured. Linux related functions and attributes now live under the `pkgs.linuxKernel` attribute set.
  In particular the versioned `linuxPackages_*` package sets (such as `linuxPackages_5_4`) and kernels from `pkgs` were moved there and now live under `pkgs.linuxKernel.packages.*`. The unversioned ones (such as `linuxPackages_latest`) remain untouched.

- In NixOS virtual machines (QEMU), the `virtualisation` module has been updated with new options:
    - [`forwardPorts`](options.html#opt-virtualisation.forwardPorts) to configure IPv4 port forwarding,
    - [`sharedDirectories`](options.html#opt-virtualisation.sharedDirectories) to set up shared host directories,
    - [`resolution`](options.html#opt-virtualisation.resolution) to set the screen resolution,
    - [`useNixStoreImage`](options.html#opt-virtualisation.useNixStoreImage) to use a disk image for the Nix store instead of 9P.

  In addition, the default [`msize`](options.html#opt-virtualisation.msize) parameter in 9P filesystems (including /nix/store and all shared directories) has been increased to 16K for improved performance.

- The setting [`services.openssh.logLevel`](options.html#opt-services.openssh.logLevel) `"VERBOSE"` `"INFO"`. This brings NixOS in line with upstream and other Linux distributions, and reduces log spam on servers due to bruteforcing botnets.

  However, if [`services.fail2ban.enable`](options.html#opt-services.fail2ban.enable) is `true`, the `fail2ban` will override the verbosity to `"VERBOSE"`, so that `fail2ban` can observe the failed login attempts from the SSH logs.

- The [`services.xserver.extraLayouts`](options.html#opt-services.xserver.extraLayouts) no longer cause additional rebuilds when a layout is added or modified.

- Sway: The terminal emulator `rxvt-unicode` is no longer installed by default via `programs.sway.extraPackages`. The current default configuration uses `alacritty` (and soon `foot`) so this is only an issue when using a customized configuration and not installing `rxvt-unicode` explicitly.

- `python3` now defaults to Python 3.9. Python 3.9 introduces many deprecation warnings, please look at the [What's New In Python 3.9 post](https://docs.python.org/3/whatsnew/3.9.html) for more information.

- `qtile` hase been updated from '0.16.0' to '0.18.0', please check [qtile changelog](https://github.com/qtile/qtile/blob/master/CHANGELOG) for changes.

- The `claws-mail` package now references the new GTK+ 3 release branch, major version 4. To use the GTK+ 2 releases, one can install the `claws-mail-gtk2` package.

- The wordpress module provides a new interface which allows to use different webservers with the new option [`services.wordpress.webserver`](options.html#opt-services.wordpress.webserver).  Currently `httpd`, `caddy` and `nginx` are supported. The definitions of wordpress sites should now be set in [`services.wordpress.sites`](options.html#opt-services.wordpress.sites).

  Sites definitions that use the old interface are automatically migrated in the new option. This backward compatibility will be removed in 22.05.

- The dokuwiki module provides a new interface which allows to use different webservers with the new option [`services.dokuwiki.webserver`](options.html#opt-services.dokuwiki.webserver).  Currently `caddy` and `nginx` are supported. The definitions of dokuwiki sites should now be set in [`services.dokuwiki.sites`](options.html#opt-services.dokuwiki.sites).

  Sites definitions that use the old interface are automatically migrated in the new option. This backward compatibility will be removed in 22.05.

- The order of NSS (host) modules has been brought in line with upstream
  recommendations:

  - The `myhostname` module is placed before the `resolve` (optional) and `dns`
    entries, but after `file` (to allow overriding via `/etc/hosts` /
    `networking.extraHosts`, and prevent ISPs with catchall-DNS resolvers from
    hijacking `.localhost` domains)
  - The `mymachines` module, which provides hostname resolution for local
    containers (registered with `systemd-machined`) is placed to the front, to
    make sure its mappings are preferred over other resolvers.
  - If systemd-networkd is enabled, the `resolve` module is placed before
    `files` and `myhostname`, as it provides the same logic internally, with
    caching.
  - The `mdns(_minimal)` module has been updated to the new priorities.

  If you use your own NSS host modules, make sure to update your priorities
  according to these rules:

  - NSS modules which should be queried before `resolved` DNS resolution should
    use mkBefore.
  - NSS modules which should be queried after `resolved`, `files` and
    `myhostname`, but before `dns` should use the default priority
  - NSS modules which should come after `dns` should use mkAfter.

- The [networking.wireless](options.html#opt-networking.wireless.enable) module (based on wpa_supplicant) has been heavily reworked, solving a number of issues and adding useful features:
  - The automatic discovery of wireless interfaces at boot has been made reliable again (issues [#101963](https://github.com/NixOS/nixpkgs/issues/101963), [#23196](https://github.com/NixOS/nixpkgs/issues/23196)).
  - WPA3 and Fast BSS Transition (802.11r) are now enabled by default for all networks.
  - Secrets like pre-shared keys and passwords can now be handled safely, meaning without including them in a world-readable file (`wpa_supplicant.conf` under /nix/store).
    This is achieved by storing the secrets in a secured [environmentFile](options.html#opt-networking.wireless.environmentFile) and referring to them though environment variables that are expanded inside the configuration.
  - With multiple interfaces declared, independent wpa_supplicant daemons are started, one for each interface (the services are named `wpa_supplicant-wlan0`, `wpa_supplicant-wlan1`, etc.).
  - The generated `wpa_supplicant.conf` file is now formatted for easier reading.
  - A new [scanOnLowSignal](options.html#opt-networking.wireless.scanOnLowSignal) option has been added to facilitate fast roaming between access points (enabled by default).
  - A new [networks.&lt;name&gt;.authProtocols](options.html#opt-networking.wireless.networks._name_.authProtocols) option has been added to change the authentication protocols used when connecting to a network.

- The [networking.wireless.iwd](options.html#opt-networking.wireless.iwd.enable) module has a new [networking.wireless.iwd.settings](options.html#opt-networking.wireless.iwd.settings) option.

- The [services.smokeping.host](options.html#opt-services.smokeping.host) option was added and defaulted to `localhost`. Before, `smokeping` listened to all interfaces by default. NixOS defaults generally aim to provide non-Internet-exposed defaults for databases and internal monitoring tools, see e.g. [#100192](https://github.com/NixOS/nixpkgs/issues/100192). Further, the systemd service for `smokeping` got reworked defaults for increased operational stability, see [PR #144127](https://github.com/NixOS/nixpkgs/pull/144127) for details.

- The [services.syncoid.enable](options.html#opt-services.syncoid.enable) module now properly drops ZFS permissions after usage. Before it delegated permissions to whole pools instead of datasets and didn't clean up after execution. You can manually look this up for your pools by running `zfs allow your-pool-name` and use `zfs unallow syncoid your-pool-name` to clean this up.

- Zfs: `latestCompatibleLinuxPackages` is now exported on the zfs package. One can use `boot.kernelPackages = config.boot.zfs.package.latestCompatibleLinuxPackages;` to always track the latest compatible kernel with a given version of zfs.

- Nginx will use the value of `sslTrustedCertificate` if provided for a virtual host, even if `enableACME` is set. This is useful for providers not using the same certificate to sign OCSP responses and server certificates.

- `lib.formats.yaml`'s `generate` will not generate JSON anymore, but instead use more of the YAML-specific syntax.

- MariaDB was upgraded from 10.5.x to 10.6.x. Please read the [upstream release notes](https://mariadb.com/kb/en/changes-improvements-in-mariadb-106/) for changes and upgrade instructions.

- The MariaDB C client library, also known as libmysqlclient or mariadb-connector-c, was upgraded from 3.1.x to 3.2.x. While this should hopefully not have any impact, this upgrade comes with some changes to default behavior, so you might want to review the [upstream release notes](https://mariadb.com/kb/en/changes-and-improvements-in-mariadb-connector-c-32/).

- GNOME desktop environment now enables `QGnomePlatform` as the Qt platform theme, which should avoid crashes when opening file chooser dialogs in Qt apps by using XDG desktop portal. Additionally, it will make the apps fit better visually.

- `rofi` has been updated from '1.6.1' to '1.7.0', one important thing is the removal of the old xresources based configuration setup. Read more [in rofi's changelog](https://github.com/davatorium/rofi/blob/cb12e6fc058f4a0f4f/Changelog#L1).

- ipfs now defaults to not listening on you local network. This setting was change as server providers won't accept port scanning on their private network. If you have several ipfs instances running on a network you own, feel free to change the setting `ipfs.localDiscovery = true;`. localDiscovery enables different instances to discover each other and share data.

- `lua` and `luajit` interpreters have been patched to avoid looking into /usr/lib
  directories, thus increasing the purity of the build.

- Three new options, [xdg.mime.addedAssociations](#opt-xdg.mime.addedAssociations), [xdg.mime.defaultApplications](#opt-xdg.mime.defaultApplications), and [xdg.mime.removedAssociations](#opt-xdg.mime.removedAssociations) have been added to the [xdg.mime](#opt-xdg.mime.enable) module to allow the configuration of `/etc/xdg/mimeapps.list`.

- Kopia was upgraded from 0.8.x to 0.9.x. Please read the [upstream release notes](https://github.com/kopia/kopia/releases/tag/v0.9.0) for changes and upgrade instructions.

- The `systemd.network` module has gained support for the FooOverUDP link type.

- The `networking` module has a new `networking.fooOverUDP` option to configure Foo-over-UDP encapsulations.

- `networking.sits` now supports Foo-over-UDP encapsulation.

-  The `virtualisation.libvirtd` module has been refactored and updated with new options:
    - `virtualisation.libvirtd.qemu*` options (e.g.: `virtualisation.libvirtd.qemuRunAsRoot`) were moved to [`virtualisation.libvirtd.qemu`](options.html#opt-virtualisation.libvirtd.qemu) submodule,
    - software TPM1/TPM2 support (e.g.: Windows 11 guests) ([`virtualisation.libvirtd.qemu.swtpm`](options.html#opt-virtualisation.libvirtd.qemu.swtpm)),
    - custom OVMF package (e.g.: `pkgs.OVMFFull` with HTTP, CSM and Secure Boot support) ([`virtualisation.libvirtd.qemu.ovmf.package`](options.html#opt-virtualisation.libvirtd.qemu.ovmf.package)).

- The `cawbird` Twitter client now uses its own API keys to count as different application than upstream builds. This is done to evade application-level rate limiting. While existing accounts continue to work, users may want to remove and re-register their account in the client to enjoy a better user experience and benefit from this change.

- A new option `services.prometheus.enableReload` has been added which can be enabled to reload the prometheus service when its config file changes instead of restarting.

- The option `services.prometheus.environmentFile` has been removed since it was causing [issues](https://github.com/NixOS/nixpkgs/issues/126083) and Prometheus now has native support for secret files, i.e. `basic_auth.password_file` and `authorization.credentials_file`.

- Dokuwiki now supports caddy! However
  - the nginx option has been removed, in the new configuration, please use the `dokuwiki.webserver = "nginx"` instead.
  - The "${hostname}" option has been deprecated, please use `dokuwiki.sites = [ "${hostname}" ]` instead

- The [services.unifi](options.html#opt-services.unifi.enable) module has been reworked, solving a number of issues. This leads to several user facing changes:
  - The `services.unifi.dataDir` option is removed and the data is now always located under `/var/lib/unifi/data`. This is done to make better use of systemd state direcotiry and thus making the service restart more reliable.
  - The unifi logs can now be found under: `/var/log/unifi` instead of `/var/lib/unifi/logs`.
  - The unifi run directory can now be found under: `/run/unifi` instead of `/var/lib/unifi/run`.

- `security.pam.services.<name>.makeHomeDir` now uses `umask=0077` instead of `umask=0022` when creating the home directory.

- Loki has had another release. Some default values have been changed for the configuration and some configuration options have been renamed. For more details, please check [the upgrade guide](https://grafana.com/docs/loki/latest/upgrading/#240).

- `julia` now refers to `julia-stable` instead of `julia-lts`. In practice this means it has been upgraded from `1.0.4` to `1.5.4`.

- RetroArch has been upgraded from version `1.8.5` to `1.9.13.2`. Since the previous release was quite old, if you're having issues after the upgrade, please delete your `$XDG_CONFIG_HOME/retroarch/retroarch.cfg` file.

- hydrus has been upgraded from version `438` to `463`. Since upgrading between releases this old is advised against, be sure to have a backup of your data before upgrading. For details, see [the hydrus manual](https://hydrusnetwork.github.io/hydrus/help/getting_started_installing.html#big_updates).

- More jdk and jre versions are now exposed via `java-packages.compiler`.
