# Release 22.05 (“Quokka”, 2022.05/??) {#sec-release-22.05}

In addition to numerous new and upgraded packages, this release has the following highlights:

- Support is planned until the end of December 2022, handing over to 22.11.

## Highlights {#sec-release-22.05-highlights}

- `security.acme.defaults` has been added to simplify configuring
  settings for many certificates at once. This also opens up the
  the option to use DNS-01 validation when using `enableACME` on
  web server virtual hosts (e.g. `services.nginx.virtualHosts.*.enableACME`).

- PHP 8.1 is now available

- Mattermost has been updated to extended support release 6.3, as the previously packaged extended support release 5.37 is [reaching its end of life](https://docs.mattermost.com/upgrade/extended-support-release.html).
  Migrations may take a while, see the [changelog](https://docs.mattermost.com/install/self-managed-changelog.html#release-v6-3-extended-support-release)
  and [important upgrade notes](https://docs.mattermost.com/upgrade/important-upgrade-notes.html).

- systemd services can now set [systemd.services.\<name\>.reloadTriggers](#opt-systemd.services) instead of `reloadIfChanged` for a more granular distinction between reloads and restarts.

## New Services {#sec-release-22.05-new-services}

- [aesmd](https://github.com/intel/linux-sgx#install-the-intelr-sgx-psw), the Intel SGX Architectural Enclave Service Manager. Available as [services.aesmd](#opt-services.aesmd.enable).

- [rootless Docker](https://docs.docker.com/engine/security/rootless/), a `systemd --user` Docker service which runs without root permissions. Available as [virtualisation.docker.rootless.enable](options.html#opt-virtualisation.docker.rootless.enable).

- [matrix-conduit](https://conduit.rs/), a simple, fast and reliable chat server powered by matrix. Available as [services.matrix-conduit](option.html#opt-services.matrix-conduit.enable).

- [filebeat](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-overview.html), a lightweight shipper for forwarding and centralizing log data. Available as [services.filebeat](#opt-services.filebeat.enable).

- [apfs](https://github.com/linux-apfs/linux-apfs-rw), a kernel module for mounting the Apple File System (APFS).

- [FRRouting](https://frrouting.org/), a popular suite of Internet routing protocol daemons (BGP, BFD, OSPF, IS-IS, VVRP and others). Available as [services.frr](#opt-services.ffr.babel.enable)

- [heisenbridge](https://github.com/hifi/heisenbridge), a bouncer-style Matrix IRC bridge. Available as [services.heisenbridge](options.html#opt-services.heisenbridge.enable).

- [ergochat](https://ergo.chat), a modern IRC with IRCv3 features. Available as [services.ergochat](options.html#opt-services.ergochat.enable).

- [PowerDNS-Admin](https://github.com/ngoduykhanh/PowerDNS-Admin), a web interface for the PowerDNS server. Available at [services.powerdns-admin](options.html#opt-services.powerdns-admin.enable).

- [input-remapper](https://github.com/sezanzeb/input-remapper), an easy to use tool to change the mapping of your input device buttons. Available at [services.input-remapper](options.html#opt-services.input-remapper.enable).

- [InvoicePlane](https://invoiceplane.com), web application for managing and creating invoices. Available at [services.invoiceplane](options.html#opt-services.invoiceplane.enable).

- [maddy](https://maddy.email), a composable all-in-one mail server. Available as [services.maddy](options.html#opt-services.maddy.enable).

- [mtr-exporter](https://github.com/mgumz/mtr-exporter), a Prometheus exporter for mtr metrics. Available as [services.mtr-exporter](options.html#opt-services.mtr-exporter.enable).

- [tetrd](https://tetrd.app), share your internet connection from your device to your PC and vice versa through a USB cable. Available at [services.tetrd](#opt-services.tetrd.enable).

- [agate](https://github.com/mbrubeck/agate), a very simple server for the Gemini hypertext protocol. Available as [services.agate](options.html#opt-services.agate.enable).

- [ArchiSteamFarm](https://github.com/JustArchiNET/ArchiSteamFarm), a C# application with primary purpose of idling Steam cards from multiple accounts simultaneously. Available as [services.archisteamfarm](options.html#opt-services.archisteamfarm.enable).

- [teleport](https://goteleport.com), allows engineers and security professionals to unify access for SSH servers, Kubernetes clusters, web applications, and databases across all environments. Available at [services.teleport](#opt-services.teleport.enable).

- [BaGet](https://loic-sharma.github.io/BaGet/), a lightweight NuGet and symbol server. Available at [services.baget](#opt-services.baget.enable).

- [moosefs](https://moosefs.com), fault tolerant petabyte distributed file system.
  Available as [moosefs](#opt-services.moosefs).

- [prosody-filer](https://github.com/ThomasLeister/prosody-filer), a server for handling XMPP HTTP Upload requests. Available at [services.prosody-filer](#opt-services.prosody-filer.enable).

- [ethercalc](https://github.com/audreyt/ethercalc), an online collaborative
  spreadsheet. Available as [services.ethercalc](options.html#opt-services.ethercalc.enable).

- [timetagger](https://timetagger.app), an open source time-tracker with an intuitive user experience and powerful reporting. [services.timetagger](options.html#opt-services.timetagger.enable).

- [rstudio-server](https://www.rstudio.com/products/rstudio/#rstudio-server), a browser-based version of the RStudio IDE for the R programming language. Available as [services.rstudio-server](options.html#opt-services.rstudio-server.enable).

- [headscale](https://github.com/juanfont/headscale), an Open Source implementation of the [Tailscale](https://tailscale.io) Control Server. Available as [services.headscale](options.html#opt-services.headscale.enable)

- [blocky](https://0xerr0r.github.io/blocky/), fast and lightweight DNS proxy as ad-blocker for local network with many features.

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

## Backward Incompatibilities {#sec-release-22.05-incompatibilities}

- `pkgs.ghc` now refers to `pkgs.targetPackages.haskellPackages.ghc`.
  This _only_ makes a difference if you are cross-compiling and will
  ensure that `pkgs.ghc` always runs on the host platform and compiles
  for the target platform (similar to `pkgs.gcc` for example).
  `haskellPackages.ghc` still behaves as before, running on the build
  platform and compiling for the host platform (similar to `stdenv.cc`).
  This means you don't have to adjust your derivations if you use
  `haskellPackages.callPackage`, but when using `pkgs.callPackage` and
  taking `ghc` as an input, you should now use `buildPackages.ghc`
  instead to ensure cross compilation keeps working (or switch to
  `haskellPackages.callPackage`).

- `pkgs.ghc.withPackages` as well as `haskellPackages.ghcWithPackages` etc.
  now needs be overridden directly, as opposed to overriding the result of
  calling it. Additionally, the `withLLVM` parameter has been renamed to
  `useLLVM`. So instead of `(ghc.withPackages (p: [])).override { withLLVM = true; }`,
  one needs to use `(ghc.withPackages.override { useLLVM = true; }) (p: [])`.

- The `home-assistant` module now requires users that don't want their
  configuration to be managed declaratively to set
  `services.home-assistant.config = null;`. This is required
  due to the way default settings are handled with the new settings style.

  Additionally the default list of `extraComponents` now includes the minimal
  dependencies to successfully complete the [onboarding](https://www.home-assistant.io/getting-started/onboarding/)
  procedure.

- `pkgs.emacsPackages.orgPackages` is removed because org elpa is deprecated.
  The packages in the top level of `pkgs.emacsPackages`, such as org and
  org-contrib, refer to the ones in `pkgs.emacsPackages.elpaPackages` and
  `pkgs.emacsPackages.nongnuPackages` where the new versions will release.

- `services.kubernetes.addons.dashboard` was removed due to it being an outdated version.

- `services.kubernetes.scheduler.{port,address}` now set `--secure-port` and `--bind-address` instead of `--port` and `--address`, since the former have been deprecated and are no longer functional in kubernetes>=1.23. Ensure that you are not relying on the insecure behaviour before upgrading.

- The DHCP server (`services.dhcpd4`, `services.dhcpd6`) has been hardened.
  The service is now using the systemd's `DynamicUser` mechanism to run as an unprivileged dynamically-allocated user with limited capabilities.
  The dhcpd state files are now always stored in `/var/lib/dhcpd{4,6}` and the `services.dhcpd4.stateDir` and `service.dhcpd6.stateDir` options have been removed.
  If you were depending on root privileges or set{uid,gid,cap} binaries in dhcpd shell hooks, you may give dhcpd more capabilities with e.g. `systemd.services.dhcpd6.serviceConfig.AmbientCapabilities`.

- The `mailpile` email webclient (`services.mailpile`) has been removed due to its reliance on python2.

- The MoinMoin wiki engine (`services.moinmoin`) has been removed, because Python 2 is being retired from nixpkgs.

- The `wafHook` hook now honors `NIX_BUILD_CORES` when `enableParallelBuilding` is not set explicitly. Packages can restore the old behaviour by setting `enableParallelBuilding=false`.

- `pkgs.claws-mail-gtk2`, representing Claws Mail's older release version three, was removed in order to get rid of Python 2.
  Please switch to `claws-mail`, which is Claws Mail's latest release based on GTK+3 and Python 3.

- The `writers.writePython2` and corresponding `writers.writePython2Bin` convenience functions to create executable Python 2 scripts in the store were removed in preparation of removal of the Python 2 interpreter.
  Scripts have to be converted to Python 3 for use with `writers.writePython3` or `writers.writePyPy2` needs to be used.

- `buildGoModule` was updated to use `go_1_17`, third party derivations that specify >= go 1.17 in the main `go.mod` will need to regenerate their `vendorSha256` hash.

- The `gnome-passwordsafe` package updated to [version 6.x](https://gitlab.gnome.org/World/secrets/-/tags/6.0) and renamed to `gnome-secrets`.

- If you previously used `/etc/docker/daemon.json`, you need to incorporate the changes into the new option `virtualisation.docker.daemon.settings`.

- The backward compatibility in `services.wordpress` to configure sites with
  the old interface has been removed. Please use `services.wordpress.sites`
  instead.

- The backward compatibility in `services.dokuwiki` to configure sites with the
  old interface has been removed. Please use `services.dokuwiki.sites` instead.

- opensmtpd-extras is no longer build with python2 scripting support due to python2 deprecation in nixpkgs

- The `autorestic` package has been upgraded from 1.3.0 to 1.5.0 which introduces breaking changes in config file, check [their migration guide](https://autorestic.vercel.app/migration/1.4_1.5) for more details.

- For `pkgs.python3.pkgs.ipython`, its direct dependency `pkgs.python3.pkgs.matplotlib-inline`
  (which is really an adapter to integrate matplotlib in ipython if it is installed) does
  not depend on `pkgs.python3.pkgs.matplotlib` anymore.
  This is closer to a non-Nix install of ipython.
  This has the added benefit to reduce the closure size of `ipython` from ~400MB to ~160MB
  (including ~100MB for python itself).

- `documentation.man` has been refactored to support choosing a man implementation other than GNU's `man-db`. For this, `documentation.man.manualPages` has been renamed to `documentation.man.man-db.manualPages`. If you want to use the new alternative man implementation `mandoc`, add `documentation.man = { enable = true; man-db.enable = false; mandoc.enable = true; }` to your configuration.

- Normal users (with `isNormalUser = true`) which have non-empty `subUidRanges` or `subGidRanges` set no longer have additional implicit ranges allocated. To enable automatic allocation back set `autoSubUidGidRange = true`.

- `idris2` now requires `--package` when using packages `contrib` and `network`, while previously these idris2 packages were automatically loaded.

- The iputils package, which is installed by default, no longer provides the
  legacy tools `tftpd` and `traceroute6`. More tools (`ninfod`, `rarpd`, and
  `rdisc`) are going to be removed in the next release. See
  [upstream's release notes](https://github.com/iputils/iputils/releases/tag/20211215)
  for more details and available replacements.

- `services.thelounge.private` was removed in favor of `services.thelounge.public`, to follow with upstream changes.

- `pkgs.docbookrx` was removed since it's unmaintained

- `tilp2` was removed together with its module

- The options `networking.interfaces.<name>.ipv4.routes` and `networking.interfaces.<name>.ipv6.routes` are no longer ignored when using networkd instead of the default scripted network backend by setting `networking.useNetworkd` to `true`.

- MultiMC has been replaced with the fork PolyMC due to upstream developers being hostile to 3rd party package maintainers. PolyMC removes all MultiMC branding and is aimed at providing proper 3rd party packages like the one contained in Nixpkgs. This change affects the data folder where game instances and other save and configuration files are stored. Users with existing installations should rename `~/.local/share/multimc` to `~/.local/share/polymc`. The main config file's path has also moved from `~/.local/share/multimc/multimc.cfg` to `~/.local/share/polymc/polymc.cfg`.


- The terraform 0.12 compatibility has been removed and the `terraform.withPlugins` and `terraform-providers.mkProvider` implementations simplified. Providers now need to be stored under
`$out/libexec/terraform-providers/<registry>/<owner>/<name>/<version>/<os>_<arch>/terraform-provider-<name>_v<version>` (which mkProvider does).

  This breaks back-compat so it's not possible to mix-and-match with previous versions of nixpkgs. In exchange, it now becomes possible to use the providers from [nixpkgs-terraform-providers-bin](https://github.com/numtide/nixpkgs-terraform-providers-bin) directly.

- The existing `pkgs.opentelemetry-collector` has been moved to
  `pkgs.opentelemetry-collector-contrib` to match the actual source being the
  "contrib" edition. `pkgs.opentelemetry-collector` is now the actual core
  release of opentelemetry-collector. If you use the community contributions
  you should change the package you refer to. If you don't need them update your
  commands from `otelcontribcol` to `otelcorecol` and enjoy a 7x smaller binary.


- `pkgs.noto-fonts-cjk` is now deprecated in favor of `pkgs.noto-fonts-cjk-sans`
  and `pkgs.noto-fonts-cjk-serif` because they each have different release
  schedules. To maintain compatibility with prior releases of Nixpkgs,
  `pkgs.noto-fonts-cjk` is currently an alias of `pkgs.noto-fonts-cjk-sans` and
  doesn't include serif fonts.

- `switch-to-configuration` (the script that is run when running `nixos-rebuild switch` for example) has been reworked
    * The interface that allows activation scripts to restart units has been streamlined. Restarting and reloading is now done by a single file `/run/nixos/activation-restart-list` that honors `restartIfChanged` and `reloadIfChanged` of the units.
        * Preferring to reload instead of restarting can still be achieved using `/run/nixos/activation-reload-list`.
    * The script now uses a proper ini-file parser to parse systemd units. Some values are now only searched in one section instead of in the entire unit. This is only relevant for units that don't use the NixOS systemd moule.
        * `RefuseManualStop`, `X-OnlyManualStart`, `X-StopOnRemoval`, `X-StopOnReconfiguration` are only searched in the `[Unit]` section
        * `X-ReloadIfChanged`, `X-RestartIfChanged`, `X-StopIfChanged` are only searched in the `[Service]` section

- The `services.bookstack.cacheDir` option has been removed, since the
  cache directory is now handled by systemd.

- The `services.bookstack.extraConfig` option has been replaced by
  `services.bookstack.config` which implements a
  [settings-style](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md)
  configuration.

- `lib.assertMsg` and `lib.assertOneOf` no longer return `false` if the passed condition is `false`, `throw`ing the given error message instead (which makes the resulting error message less cluttered). This will not impact the behaviour of code using these functions as intended, namely as top-level wrapper for `assert` conditions.

- `pkgs.vimPlugins.onedark-nvim` now refers to [navarasu/onedark.nvim](https://github.com/navarasu/onedark.nvim)
  (formerly refers to [olimorris/onedarkpro.nvim](https://github.com/olimorris/onedarkpro.nvim)).

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->

## Other Notable Changes {#sec-release-22.05-notable-changes}

- The option [services.redis.servers](#opt-services.redis.servers) was added
  to support per-application `redis-server` which is more secure since Redis databases
  are only mere key prefixes without any configuration or ACL of their own.
  Backward-compatibility is preserved by mapping old `services.redis.settings`
  to `services.redis.servers."".settings`, but you are strongly encouraged
  to name each `redis-server` instance after the application using it,
  instead of keeping that nameless one.
  Except for the nameless `services.redis.servers.""`
  still accessible at `127.0.0.1:6379`,
  and to the members of the Unix group `redis`
  through the Unix socket `/run/redis/redis.sock`,
  all other `services.redis.servers.${serverName}`
  are only accessible by default
  to the members of the Unix group `redis-${serverName}`
  through the Unix socket `/run/redis-${serverName}/redis.sock`.

- The option [virtualisation.vmVariant](#opt-virtualisation.vmVariant) was added
  to allow users to make changes to the `nixos-rebuild build-vm` configuration
  that do not apply to their normal system.

  The `config.system.build.vm` attribute now always exists and defaults to the
  value from `vmVariant`. Configurations that import the `virtualisation/qemu-vm.nix`
  module themselves will override this value, such that `vmVariant` is not used.

  Similarly [virtualisation.vmVariantWithBootloader](#opt-virtualisation.vmVariantWithBootLoader) was added.

- The configuration portion of the `nix-daemon` module has been reworked and exposed as [nix.settings](options.html#opt-nix-settings):
  * Legacy options have been mapped to the corresponding options under under [nix.settings](options.html#opt-nix.settings) but may be deprecated in the future.
  * [nix.buildMachines.publicHostKey](options.html#opt-nix.buildMachines.publicHostKey) has been added.

- The `writers.writePyPy2`/`writers.writePyPy3` and corresponding `writers.writePyPy2Bin`/`writers.writePyPy3Bin` convenience functions to create executable Python 2/3 scripts using the PyPy interpreter were added.

- If you are using Wayland you can choose to use the Ozone Wayland support
  in Chrome and several Electron apps by setting the environment variable
  `NIXOS_OZONE_WL=1` (for example via
  `environment.sessionVariables.NIXOS_OZONE_WL = "1"`).
  This is not enabled by default because Ozone Wayland is
  still under heavy development and behavior is not always flawless.
  Furthermore, not all Electron apps use the latest Electron versions.

- The `influxdb2` package was split into `influxdb2-server` and
  `influxdb2-cli`, matching the split that took place upstream. A
  combined `influxdb2` package is still provided in this release for
  backwards compatibilty, but will be removed at a later date.

- The `services.unifi.openPorts` option default value of `true` is now deprecated and will be changed to `false` in 22.11.
  Configurations using this default will print a warning when rebuilt.

- `security.acme` certificates will now correctly check for CA
  revokation before reaching their minimum age.

- Removing domains from `security.acme.certs._name_.extraDomainNames`
  will now correctly remove those domains during rebuild/renew.

- MariaDB is now offered in several versions, not just the newest one.
  So if you have a need for running MariaDB 10.4 for example, you can now just set `services.mysql.package = pkgs.mariadb_104;`.
  In general, it is recommended to run the newest version, to get the newest features, while sticking with an LTS version will most likely provide a more stable experience.
  Sometimes software is also incompatible with the newest version of MariaDB.

- The option
  [programs.ssh.enableAskPassword](#opt-programs.ssh.enableAskPassword) was
  added, decoupling the setting of `SSH_ASKPASS` from
  `services.xserver.enable`. This allows easy usage in non-X11 environments,
  e.g. Wayland.

- [programs.ssh.knownHosts](#opt-programs.ssh.knownHosts) has gained an `extraHostNames`
  option to replace `hostNames`. `hostNames` is deprecated, but still available for now.

- The `services.stubby` module was converted to a [settings-style](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md) configuration.

- The option `services.duplicati.dataDir` has been added to allow changing the location of duplicati's files.

- A new option `boot.initrd.extraModprobeConfig` has been added which can be used to configure kernel modules that are loaded in the initrd.

- `nixos-generate-config` now puts the dhcp configuration in `hardware-configuration.nix` instead of `configuration.nix`.

- `fetchFromSourcehut` now allows fetching repositories recursively
  using `fetchgit` or `fetchhg` if the argument `fetchSubmodules`
  is set to `true`.

- The option `services.thelounge.plugins` has been added to allow installing plugins for The Lounge. Plugins can be found in `pkgs.theLoungePlugins.plugins` and `pkgs.theLoungePlugins.themes`.

- The `firmwareLinuxNonfree` package has been renamed to `linux-firmware`.

- The `services.mbpfan` module was converted to a [RFC 0042](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md) configuration.

- The default value for `programs.spacefm.settings.graphical_su` got unset. It previously pointed to `gksu` which has been removed.

- A new module was added for the [Starship](https://starship.rs/) shell prompt,
  providing the options `programs.starship.enable` and `programs.starship.settings`.

- `services.mattermost.plugins` has been added to allow the declarative installation of Mattermost plugins.
  Plugins are automatically repackaged using autoPatchelf.

- The `zrepl` package has been updated from 0.4.0 to 0.5:

  - The RPC protocol version was bumped; all zrepl daemons in a setup must be updated and restarted before replication can resume.
  - A bug involving encrypt-on-receive has been fixed. Read the [zrepl documentation](https://zrepl.github.io/configuration/sendrecvoptions.html#job-recv-options-placeholder) and check the output of `zfs get -r encryption,zrepl:placeholder PATH_TO_ROOTFS` on the receiver.

- Renamed option `services.openssh.challengeResponseAuthentication` to `services.openssh.kbdInteractiveAuthentication`.
  Reason is that the old name has been deprecated upstream.
  Using the old option name will still work, but produce a warning.

- The option
  [services.networking.networkmanager.enableFccUnlock](#opt-services.networking.networkmanager.enableFccUnlock)
  was added to support FCC unlock procedures. Since release 1.18.4, the ModemManager
  daemon no longer automatically performs the FCC unlock procedure by default. See
  [the docs](https://modemmanager.org/docs/modemmanager/fcc-unlock/) for more details.

- `programs.tmux` has a new option `plugins` that accepts a list of packages from the `tmuxPlugins` group. The specified packages are added to the system and loaded by `tmux`.

<!-- To avoid merge conflicts, consider adding your item at an arbitrary place in the list instead. -->
