{ cfg, pkgs, lib }:
let
  propertyXml = name: value: ''
    <property>
      <name>${name}</name>
      <value>${builtins.toString value}</value>
    </property>
  '';
  siteXml = fileName: properties: pkgs.writeTextDir fileName ''
    <?xml version="1.0" encoding="UTF-8" standalone="no"?>
    <!-- generated by NixOS -->
    <configuration>
      ${builtins.concatStringsSep "\n" (pkgs.lib.mapAttrsToList propertyXml properties)}
    </configuration>
  '';
  cfgLine = name: value: ''
    ${name}=${builtins.toString value}
  '';
  cfgFile = fileName: properties: pkgs.writeTextDir fileName ''
    # generated by NixOS
    ${builtins.concatStringsSep "" (pkgs.lib.mapAttrsToList cfgLine properties)}
  '';
  userFunctions = ''
    hadoop_verify_logdir() {
      echo Skipping verification of log directory
    }
  '';
  hadoopEnv = ''
    export HADOOP_LOG_DIR=/tmp/hadoop/$USER
  '';
in
pkgs.runCommand "hadoop-conf" {} ''
  mkdir -p $out/
  cp ${siteXml "core-site.xml" cfg.coreSite}/* $out/
  cp ${siteXml "hdfs-site.xml" cfg.hdfsSite}/* $out/
  cp ${siteXml "mapred-site.xml" cfg.mapredSite}/* $out/
  cp ${siteXml "yarn-site.xml" cfg.yarnSite}/* $out/
  cp ${siteXml "httpfs-site.xml" cfg.httpfsSite}/* $out/
  cp ${cfgFile "container-executor.cfg" cfg.containerExecutorCfg}/* $out/
  cp ${pkgs.writeTextDir "hadoop-user-functions.sh" userFunctions}/* $out/
  cp ${pkgs.writeTextDir "hadoop-env.sh" hadoopEnv}/* $out/
  cp ${cfg.log4jProperties} $out/log4j.properties
  ${lib.concatMapStringsSep "\n" (dir: "cp -r ${dir}/* $out/") cfg.extraConfDirs}
''
