# generated by clj2nix-1.0.5
{ pkgs ? import <nixpkgs> {} }:

  let repos = [
        "https://repo1.maven.org/maven2/"
        "https://repo.clojars.org/"
        "http://oss.sonatype.org/content/repositories/releases/"
        "http://oss.sonatype.org/content/repositories/public/"
        "http://repo.typesafe.com/typesafe/releases/"
      ];

  in rec {
      makePaths = {extraClasspaths ? []}: (builtins.map (dep: if builtins.hasAttr "jar" dep.path then dep.path.jar else dep.path) packages) ++ extraClasspaths;
      makeClasspaths = {extraClasspaths ? []}: builtins.concatStringsSep ":" (makePaths {inherit extraClasspaths;});

      packages = [
  {
    name = "javax.inject/javax.inject";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "javax.inject";
      groupId = "javax.inject";
      sha512 = "e126b7ccf3e42fd1984a0beef1004a7269a337c202e59e04e8e2af714280d2f2d8d2ba5e6f59481b8dcd34aaf35c966a688d0b48ec7e96f102c274dc0d3b381e";
      version = "1";
    };
  }

  {
    name = "org.clojure/data.json";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "data.json";
      groupId = "org.clojure";
      sha512 = "ce526bef01bedd31b772954d921a61832ae60af06121f29080853f7932326438b33d183240a9cffbe57e00dc3744700220753948da26b8973ee21c30e84227a6";
      version = "0.2.6";
    };
  }

  {
    name = "org.clojure/clojure";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "clojure";
      groupId = "org.clojure";
      sha512 = "f28178179483531862afae13e246386f8fda081afa523d3c4ea3a083ab607d23575d38ecb9ec0ee7f4d65cbe39a119f680e6de4669bc9cf593aa92be0c61562b";
      version = "1.10.1";
    };
  }

  {
    name = "net.cgrand/sjacket";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "sjacket";
      groupId = "net.cgrand";
      sha512 = "34a359a0a633f116147e5bd52d4f4a9cd755636ce0e8abf155da9c3f04b07f93bbbf7c1f8e370db922e14da0efd36a5b127ff9e564141ca7a843f0498a8b860a";
      version = "0.1.1";
    };
  }

  {
    name = "clojupyter/clojupyter";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "clojupyter";
      groupId = "clojupyter";
      sha512 = "3ff95101e9031f0678c1ebd67b0f0d1b50495aa81a69c8f08deb9c2931818bbdd6bcd6f1ef25c407c6714a975c1ef853b4287725641a3fed7b93e1c27ba78709";
      version = "0.3.2";
    };
  }

  {
    name = "commons-codec/commons-codec";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "commons-codec";
      groupId = "commons-codec";
      sha512 = "b65531ead8500493e3dd14a860224851b80f438fc53bf8868b443a0557d839a2b0c868e4fedcf99579ae04b6b2bbd8cdb37f9921ad785983c37569aa9d2e8102";
      version = "1.9";
    };
  }

  {
    name = "org.clojure/tools.analyzer";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "tools.analyzer";
      groupId = "org.clojure";
      sha512 = "9cce94540a6fd0ae0bad915efe9a30c8fb282fbd1e225c4a5a583273e84789b3b5fc605b06f11e19d7dcc212d08bc6138477accfcde5d48839bec97daa874ce6";
      version = "0.6.9";
    };
  }

  {
    name = "org.codehaus.plexus/plexus-component-annotations";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "plexus-component-annotations";
      groupId = "org.codehaus.plexus";
      sha512 = "e20aa9fdb3fda4126f55ef45c36362138c6554ede40fa266ff6b63fe1c3b4d699f9eb95793f26527e096ec7567874aa7af5fe84124815729fdb2d4abaa9ddea8";
      version = "1.7.1";
    };
  }

  {
    name = "org.apache.commons/commons-compress";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "commons-compress";
      groupId = "org.apache.commons";
      sha512 = "f3e077ff7f69992961d744dc513eca93606e472e3733657636808a7f50c17f39e3de8367a1af7972cb158f05725808627b6232585a81f197c0da3eff0336913e";
      version = "1.8";
    };
  }

  {
    name = "org.apache.commons/commons-lang3";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "commons-lang3";
      groupId = "org.apache.commons";
      sha512 = "9e6ff20e891b6835d5926c90f237d55931e75723c8b88d6417926393e077e71013dab006372d34a6b5801e6ca3ce080a00f202cba700cab5aabfc17bbbdcab36";
      version = "3.5";
    };
  }

  {
    name = "org.clojure/core.specs.alpha";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "core.specs.alpha";
      groupId = "org.clojure";
      sha512 = "348c0ea0911bc0dcb08655e61b97ba040649b4b46c32a62aa84d0c29c245a8af5c16d44a4fa5455d6ab076f4bb5bbbe1ad3064a7befe583f13aeb9e32a169bf4";
      version = "0.2.44";
    };
  }

  {
    name = "org.tukaani/xz";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "xz";
      groupId = "org.tukaani";
      sha512 = "c5c130bf22f24f61b57fc0c6243e7f961ca2a8928416e8bb288aec6650c1c1c06ace4383913cd1277fc6785beb9a74458807ea7e3d6b2e09189cfaf2fb9ab7e1";
      version = "1.5";
    };
  }

  {
    name = "org.zeromq/jeromq";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "jeromq";
      groupId = "org.zeromq";
      sha512 = "0965b82a10136a656dfe48268008536a57b26be9190ff2f3d5dbf3fa298e21bc754e70b1e7fae1aca782d25c397c9ce8fa3832783665391142b31dc4a1bd0233";
      version = "0.5.1";
    };
  }

  {
    name = "org.clojure/spec.alpha";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "spec.alpha";
      groupId = "org.clojure";
      sha512 = "18c97fb2b74c0bc2ff4f6dc722a3edec539f882ee85d0addf22bbf7e6fe02605d63f40c2b8a2905868ccd6f96cfc36a65f5fb70ddac31c6ec93da228a456edbd";
      version = "0.2.176";
    };
  }

  {
    name = "pandect/pandect";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "pandect";
      groupId = "pandect";
      sha512 = "8c265289f46a94cf2400f05223cdd3f9faee9a39e6ed5a55a3e89b09334a61e928c0f27e2db834edf3b544e2148a511bccf1ef73132bd9263659bed381abb59a";
      version = "0.6.1";
    };
  }

  {
    name = "org.clojure/tools.cli";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "tools.cli";
      groupId = "org.clojure";
      sha512 = "9baf3fafe2e92b846404ef1bd897a4a335fe4bc1f78a2408ee93c09dc960a630f58a0e863b2d299624783f2851bb5d83f93fa627276d28d66c92764c46f27efe";
      version = "0.4.2";
    };
  }

  {
    name = "com.taoensso/encore";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "encore";
      groupId = "com.taoensso";
      sha512 = "c4928c76378415ac504071ae4812e82efdce3b432c961b0bb9d906a468bb9c51a778f0109ac86641419b1a852ef13ca3d5c54ddde457e5aaec36a2f54f9caf8f";
      version = "2.91.0";
    };
  }

  {
    name = "org.apache.maven.resolver/maven-resolver-transport-wagon";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-resolver-transport-wagon";
      groupId = "org.apache.maven.resolver";
      sha512 = "b7a4dcd2f9bb39bfd561e9b2a8fc087bd9e7e59136ea7787341c173fa22c6b8e9370117ed6c30b0c930dd5b188fab2f2b060042861df19e79772a74c703fcf64";
      version = "1.0.3";
    };
  }

  {
    name = "org.slf4j/jcl-over-slf4j";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "jcl-over-slf4j";
      groupId = "org.slf4j";
      sha512 = "d9c08c3e4cb18b2d69ba8bcd4bbf3955dbc287e20141d244486f6237c36e8e2cf86ae48c295b5dd579219b5c7b1197658153f10fce73d155a4a1d4e6c7943952";
      version = "1.7.22";
    };
  }

  {
    name = "org.clojure/tools.analyzer.jvm";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "tools.analyzer.jvm";
      groupId = "org.clojure";
      sha512 = "ec1cb7638e38dfdca49c88e0b71ecf9c6ea858dccd46a2044bb37d01912ab4709b838cd2f0d1c2f201927ba4eea8f68d4d82e9fdd6da2f9943f7239bf86549f2";
      version = "0.7.2";
    };
  }

  {
    name = "org.apache.maven.wagon/wagon-provider-api";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "wagon-provider-api";
      groupId = "org.apache.maven.wagon";
      sha512 = "4571002ad5bfc0442bb2eaf32ec42675dc0a179413230615475842bba12fb561159ffc0213127cf241088641a218627e84049b715b9e71ed83d960f4f09da985";
      version = "3.0.0";
    };
  }

  {
    name = "io.pedestal/pedestal.log";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "pedestal.log";
      groupId = "io.pedestal";
      sha512 = "f6c4d8e1b202af9ef7950ec6d02b96f0e598e8d1f9ffffe8e5650e8ffdebd6c4919166aa83e34f47407870473024d28e7a49a2a0ad2b9af221514e42c518baae";
      version = "0.5.7";
    };
  }

  {
    name = "org.clojure/tools.macro";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "tools.macro";
      groupId = "org.clojure";
      sha512 = "18fb889ec7f0c8f23084f01587582be3c1baaa475249c40cfa8edc78c75079807ed49f2fb714a5c79b16bcf233142abcf571b12fff4e29cd78850c0016d6b4b9";
      version = "0.1.1";
    };
  }

  {
    name = "com.fasterxml.jackson.dataformat/jackson-dataformat-cbor";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "jackson-dataformat-cbor";
      groupId = "com.fasterxml.jackson.dataformat";
      sha512 = "dd49d4a154b8284620704a364ec54fb94638d68424b4f3eaa1d61cccc70959d399e539162f6ac8dcdd6efb0d3817a2edd2bba12fd2630cabd4722cd2ce9b782a";
      version = "2.9.6";
    };
  }

  {
    name = "org.flatland/useful";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "useful";
      groupId = "org.flatland";
      sha512 = "b97c92692e36be3e4bdfe4a6b1f1ecb2729c960c25884d1cb12218d0b807789dc37120022b4dd0fd5daba1dd16f892ac134576f84ef301c23525ba55cb041e2d";
      version = "0.11.6";
    };
  }

  {
    name = "org.apache.maven.resolver/maven-resolver-transport-http";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-resolver-transport-http";
      groupId = "org.apache.maven.resolver";
      sha512 = "97c23620a57406a8d87a08ab2897355afcce4b53b397ef7d13b4254cb07e965b51f05e21ce2d77ea93c4dbc63f32b3f07ff2171bccfe2b4f21116569968a003e";
      version = "1.0.3";
    };
  }

  {
    name = "net.cgrand/parsley";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "parsley";
      groupId = "net.cgrand";
      sha512 = "e114f9e5709b9a38214aabc2b7bb33984693a4302fd8570bb91956bce2755d69b6ee2eaa7224137e306ab1f830672eee928e030677f50739edc62314429fa1f7";
      version = "0.9.3";
    };
  }

  {
    name = "funcool/cats";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "cats";
      groupId = "funcool";
      sha512 = "83ccb058078c3c380435512e6f92cfc117244fab4819db776eb963d3b488ac92ca70a783b5d3b776d9d4cf06d9de5d3730c07ce6e7013e6717ba28335601ece8";
      version = "2.3.2";
    };
  }

  {
    name = "org.apache.maven/maven-model-builder";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-model-builder";
      groupId = "org.apache.maven";
      sha512 = "6684b58d14e7d037f240ae15ee0456d27354c9dd93a1dc2bdbb66f399b012ffe8ff67a1dd83ee1e45c07fd91af77909a9c19d6b29791002d5b5acf23ca75dcb2";
      version = "3.5.3";
    };
  }

  {
    name = "io.aviso/pretty";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "pretty";
      groupId = "io.aviso";
      sha512 = "2c4df86bb572cf028992a1a321178df65d0e681cbbc699db3a149fd0bcf8ad803643bf4e621a9b7793067f128934819371796468288cf5822924b2218711ccac";
      version = "0.1.33";
    };
  }

  {
    name = "rewrite-clj/rewrite-clj";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "rewrite-clj";
      groupId = "rewrite-clj";
      sha512 = "14018072e5c9466e8cafc08d68633f0d0a410ceb6631bd48cf7d67056e5bc972618f1b3f80ba00c4fdf88ad884fe58b636945ec6f053cbe14aee61ef173e12d3";
      version = "0.6.1";
    };
  }

  {
    name = "org.codehaus.plexus/plexus-utils";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "plexus-utils";
      groupId = "org.codehaus.plexus";
      sha512 = "3805c57b7297459c5e2754d0fd56abd454eee08691974fb930ebb9b79a529fd874f16d40cec66e7fd90d4146c9d1fef45cdb59f9e359fce0c48ac77526fc320d";
      version = "3.1.0";
    };
  }

  {
    name = "org.apache.maven.resolver/maven-resolver-transport-file";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-resolver-transport-file";
      groupId = "org.apache.maven.resolver";
      sha512 = "a83cc067c0857f091787120dcbde00f2df5cd6379a02cca95a091aa243ca22dfbae634406c58373b391caf911dd6db3b4ff4a3d51768f4a61b1081e7c78bb252";
      version = "1.0.3";
    };
  }

  {
    name = "slingshot/slingshot";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "slingshot";
      groupId = "slingshot";
      sha512 = "ff2b2a27b441d230261c7f3ec8c38aa551865e05ab6438a74bd12bfcbc5f6bdc88199d42aaf5932b47df84f3d2700c8f514b9f4e9b5da28d29da7ff6b09a7fb5";
      version = "0.12.2";
    };
  }

  {
    name = "org.flatland/ordered";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "ordered";
      groupId = "org.flatland";
      sha512 = "16ba9c232cefcf363c603af95343db3f86538e3829dce9fba9adce48c3bf2e80c24e4e30a4583750d124aeb9f1031cdbe93d08796366484495b1b22857de3045";
      version = "1.5.7";
    };
  }

  {
    name = "commons-io/commons-io";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "commons-io";
      groupId = "commons-io";
      sha512 = "1f6bfc215da9ae661dbabba80a0f29101a2d5e49c7d0c6ed760d1cafea005b7f0ff177b3b741e75b8e59804b0280fa453a76940b97e52b800ec03042f1692b07";
      version = "2.5";
    };
  }

  {
    name = "org.apache.maven.wagon/wagon-http-shared";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "wagon-http-shared";
      groupId = "org.apache.maven.wagon";
      sha512 = "d4ef092c8ca8efd4295323d7bdb98315fcf574c2e5e227840847b936ab36095217583c5a807a27e21b831ade4cfbaa570278aa0d1a0144e92b90a42099b541f1";
      version = "3.0.0";
    };
  }

  {
    name = "com.fasterxml.jackson.core/jackson-core";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "jackson-core";
      groupId = "com.fasterxml.jackson.core";
      sha512 = "a1b9b68b67d442a47e36b46b37b6b0ad7a10c547a1cf7adb4705baec77356e1080049d310b3b530f66bbd3c0ed05cfe43c041d6ef4ffbbc6731149624df4e699";
      version = "2.9.6";
    };
  }

  {
    name = "org.yaml/snakeyaml";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "snakeyaml";
      groupId = "org.yaml";
      sha512 = "b7ef491ded21c61260d6ad68b1541d0c753f01f3f065b66a31c8e4d8f5f6b5eff31e82a7cc68562567811cc0d540c980e8a42714574f50e7713b4799192f50f9";
      version = "1.19";
    };
  }

  {
    name = "org.slf4j/jul-to-slf4j";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "jul-to-slf4j";
      groupId = "org.slf4j";
      sha512 = "e76ee7ee3e1852be55c18ccb7a8f4a7005807da3cbd97f4b4895632fee92cc64785491d4f6384ae4ebd0f73a1ee4893dc1adf7119da056300f21eb2e7d3f233f";
      version = "1.7.14";
    };
  }

  {
    name = "org.apache.httpcomponents/httpcore";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "httpcore";
      groupId = "org.apache.httpcomponents";
      sha512 = "10814bfb8dcce31034f8fd6822f9da29299529b900616b78d8caf846748cf2b1e093f7b99db26a8580266e3346b822b5edb347004b0d13580e6df85cb327c93c";
      version = "4.4.6";
    };
  }

  {
    name = "io.pedestal/pedestal.interceptor";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "pedestal.interceptor";
      groupId = "io.pedestal";
      sha512 = "9767bb8df4ec3d1ee1468c22afd64adc689bb0ae15e98dfc04ef98e65f237f67ded3ade9c1514d2e44e1dd56dbff6cafbc9795a5c57e166cb924f43175c3be83";
      version = "0.5.7";
    };
  }

  {
    name = "io.dropwizard.metrics/metrics-core";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "metrics-core";
      groupId = "io.dropwizard.metrics";
      sha512 = "4b500efcc88e717dbbfff9629e12db0f23380bc7dbae820039ed730cdaf26fb6d5be6e58434bd6f688ea3d675576e2057ec183472aac99189817fc28b3c3489e";
      version = "4.1.0";
    };
  }

  {
    name = "com.grammarly/omniconf";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "omniconf";
      groupId = "com.grammarly";
      sha512 = "f9b162b98676cb5073310309aac9678725cb4a7eec3fe00803b21ce4abcea3cc1c41df5e970105ed18352619dfab40c0736ae78e9206165f17b0094107b2594b";
      version = "0.3.2";
    };
  }

  {
    name = "clj-tuple/clj-tuple";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "clj-tuple";
      groupId = "clj-tuple";
      sha512 = "dd626944d0aba679a21b164ed0c77ea84449359361496cba810f83b9fdeab751e5889963888098ce4bf8afa112dbda0a46ed60348a9c01ad36a2e255deb7ab6d";
      version = "0.2.2";
    };
  }

  {
    name = "eu.neilalexander/jnacl";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "jnacl";
      groupId = "eu.neilalexander";
      sha512 = "addba1eae1975a71a204557dafb111c5c2aab39d9a7bb6428a26107935d95290139381c0a283b77e67b44e1d8110d3fa3919d7e7fc73e0023771beece4eab994";
      version = "1.0.0";
    };
  }

  {
    name = "zprint/zprint";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "zprint";
      groupId = "zprint";
      sha512 = "379b6f9228ec0b5ae1a24b0cce4c41e273534b456cf356ac67b7f72a7506345eddf7f7ac75c2c200864d5372c1fb0331d2b31bc22a21c496cafdfe839241e9f9";
      version = "0.4.15";
    };
  }

  {
    name = "com.taoensso/truss";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "truss";
      groupId = "com.taoensso";
      sha512 = "601bdac92eb0432de228717d3feb7f8a24f484eaf8b93a98c95ee42a0d57bd3dd7d2929c21dadb3a9b43d5e449821d30bbcf4e5ae198dcb8c62ec9597ff57524";
      version = "1.5.0";
    };
  }

  {
    name = "org.apache.maven.resolver/maven-resolver-api";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-resolver-api";
      groupId = "org.apache.maven.resolver";
      sha512 = "d00cd4ec92bfafe88d9c4f4ce91e6c2d581d416a096743d396c1712a5788239cf2d55f910e1c0024034f7e0d8028ff602339b87c8fd3ad54f665a8b63d142e67";
      version = "1.1.1";
    };
  }

  {
    name = "hiccup/hiccup";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "hiccup";
      groupId = "hiccup";
      sha512 = "034f15be46c35029f41869c912f82cb2929fbbb0524ea64bd98dcdb9cf09875b28c75e926fa5fff53942b0f9e543e85a73a2d03c3f2112eecae30fcef8b148f4";
      version = "1.0.5";
    };
  }

  {
    name = "io.opentracing/opentracing-api";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "opentracing-api";
      groupId = "io.opentracing";
      sha512 = "931197ca33e509570e389cd163af96e277bb3635f019e34e2fc97d3fa9c34bb9042f25b2ba8aa59f8516cc044ec3e9584462601b8aa5f954bbc6ad88e5fbe5cd";
      version = "0.33.0";
    };
  }

  {
    name = "org.apache.maven/maven-resolver-provider";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-resolver-provider";
      groupId = "org.apache.maven";
      sha512 = "ec9e402084886554d247232b3dc5a971f6cbc93206759104ee7f94c7ba3ea2d69a715c68e479d2c64f6fe5045b6d7bd75cc3bb239462464ac608b0db1a5f0db5";
      version = "3.5.3";
    };
  }

  {
    name = "commons-logging/commons-logging";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "commons-logging";
      groupId = "commons-logging";
      sha512 = "ed00dbfabd9ae00efa26dd400983601d076fe36408b7d6520084b447e5d1fa527ce65bd6afdcb58506c3a808323d28e88f26cb99c6f5db9ff64f6525ecdfa557";
      version = "1.2";
    };
  }

  {
    name = "com.google.guava/guava";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "guava";
      groupId = "com.google.guava";
      sha512 = "d8736b5151df2dd052c09548a118af15a8b8b40999954cd093cfd301445accb8b7e9532b36bac8b2fab9234a24e2e05009a33d0a8e149e841ebddbcc733a8e4c";
      version = "20.0";
    };
  }

  {
    name = "com.fzakaria/slf4j-timbre";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "slf4j-timbre";
      groupId = "com.fzakaria";
      sha512 = "93ecc0e133a3f02f521cac125fd8842f94f2c284000b6b9f1cda7ef2841567bd674facea1f8c4e32da2321f414c1f2590ac58abf37f23347f6f551fcd9039339";
      version = "0.3.14";
    };
  }

  {
    name = "clojure.java-time/clojure.java-time";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "clojure.java-time";
      groupId = "clojure.java-time";
      sha512 = "a7111b5c78d7f920d74793d410f81c9ca3c9a8c4d652f132be55eb15f6d03a413cee1ae46bad6d3189c045d422a33c7320fbd02055c351779c379f75db48cbbd";
      version = "0.3.2";
    };
  }

  {
    name = "org.apache.maven.resolver/maven-resolver-spi";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-resolver-spi";
      groupId = "org.apache.maven.resolver";
      sha512 = "bb58083c5ef2b6d3915acb368c80bd55ca6318925c606ad74e3e4ab2fc0066c7fa2480cefa34487c5349f1edff02131bbaa4c3a426f9a52d5a6a66a4a023d452";
      version = "1.1.1";
    };
  }

  {
    name = "org.clojure/algo.generic";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "algo.generic";
      groupId = "org.clojure";
      sha512 = "2ded22096f7bf051fcc649d56fdb0ef2dddcb5490e22ce4d7e6f714d910db0cc7d453862b2180169641c21f0754b799036e4b0e7944c79f29d22dcb4152e384d";
      version = "0.1.3";
    };
  }

  {
    name = "com.taoensso/timbre";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "timbre";
      groupId = "com.taoensso";
      sha512 = "cbb47d1ba312ca5f8ffdb2953401e0b37b308529c49622d4eb57e1d128ae56768051a2e01264c3a3fe8ef1c8a8785fcc29bc9336ccc70e629f2ab432280e6d7f";
      version = "4.10.0";
    };
  }

  {
    name = "org.clojure/java.jdbc";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "java.jdbc";
      groupId = "org.clojure";
      sha512 = "50c263853f0b88d4b46746bf8f5efb8536f38dde2a08c26e5d26c2bd3bd851c0c0f0814d7899019c3879de2667b3b432a23de091bd8f8cea3e28bd00f0b715cb";
      version = "0.7.9";
    };
  }

  {
    name = "org.apache.maven.wagon/wagon-http";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "wagon-http";
      groupId = "org.apache.maven.wagon";
      sha512 = "e565e6541d53a5c2823a211586163707a5dbf5d9b3dd9f4a8d1d9dd2ffc0c8cf3ef2adb78d455235d22ede99d2e4619eb7f94d2a52eb0ffd119b52b33f9d89ba";
      version = "3.0.0";
    };
  }

  {
    name = "io.opentracing/opentracing-noop";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "opentracing-noop";
      groupId = "io.opentracing";
      sha512 = "c727bcf20504fa72bfc07456bdde3b0b50988632d85c7af78df742efd90a431c125f5d644273203fa211a62fc4a282455cf281c7c82b82df4695afbc5488577f";
      version = "0.33.0";
    };
  }

  {
    name = "net.cgrand/regex";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "regex";
      groupId = "net.cgrand";
      sha512 = "f0dfa4727818765364ce1793337597b06a2f95364245ab6c860e2373a98da55771e77a7eb772dcf415a336d8caad35673d5054e18b9494c3e1b9f882fecfb4d9";
      version = "1.1.0";
    };
  }

  {
    name = "cider/cider-nrepl";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "cider-nrepl";
      groupId = "cider";
      sha512 = "2c665aeb6c31eb2d11f257966f19e6127d602546a8fea2ab19eed3352469f93bd870c210250cc3f8b89d68d61f6076a614b87d1792a1ab3a3fd8f3b974842f75";
      version = "0.21.1";
    };
  }

  {
    name = "com.cemerick/pomegranate";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "pomegranate";
      groupId = "com.cemerick";
      sha512 = "a08137b575305aeff9858b93fc1febba92aaff27d9994e884c0e614f43704403cfb7e3e8d819a8151966c6439c178f4fb371003c392591dbc87b9e0fa64788fd";
      version = "1.1.0";
    };
  }

  {
    name = "org.codehaus.plexus/plexus-interpolation";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "plexus-interpolation";
      groupId = "org.codehaus.plexus";
      sha512 = "d9183dc0920fb996901644903194883d1e1d1e8c4863f3c55bd6a9b14de996ee30651849435a92c8c55fc82be0e4524f1b2741957f9464434da292188ffcee70";
      version = "1.24";
    };
  }

  {
    name = "org.apache.httpcomponents/httpclient";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "httpclient";
      groupId = "org.apache.httpcomponents";
      sha512 = "f8d4a960ed235770570afaf793c4596404adfa777e08bdb87ae2db92575db5e11755025fe43969f852ef505a390833e79bdd1fccd5f3fb7dee87625607b504a2";
      version = "4.5.3";
    };
  }

  {
    name = "cheshire/cheshire";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "cheshire";
      groupId = "cheshire";
      sha512 = "46d638d3e261e2debcaae9bdf912abaad4e77218ee0ba25ad0ff71dc040f579e630e593d55cd84dc9815bf84df33650295243cbeb8ff868976854544dd77de2c";
      version = "5.8.1";
    };
  }

  {
    name = "tigris/tigris";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "tigris";
      groupId = "tigris";
      sha512 = "5393fe3f656521a6760d289d9549ffb9e9c1a8a72b69878205d53763802afa8778f1cb8bed6899e0b9721de231a79b8b1254cc601c84f5374467f1cc4780a987";
      version = "0.1.1";
    };
  }

  {
    name = "org.clojure/core.match";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "core.match";
      groupId = "org.clojure";
      sha512 = "d69ed23bad115ed665b402886e1946fcecacbbfd05150f3eb66dce9ffc0381d0e02ed6f41cb390a6dfb74f4f26e3b0f6793dec38f6a4622dc53c0739d79f5f5e";
      version = "0.3.0";
    };
  }

  {
    name = "org.clojure/tools.reader";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "tools.reader";
      groupId = "org.clojure";
      sha512 = "3d6d184a30cead093a158a69feaff8685a24a8089b0245f2b262d26ff46c7fd0be6940bdaccb0b5b06f87cba7ac59e677f74afff1cfbd67dc2b32e2a1ff19541";
      version = "1.2.2";
    };
  }

  {
    name = "org.tcrawley/dynapath";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "dynapath";
      groupId = "org.tcrawley";
      sha512 = "1b0caf390515212e6b151d6c227b1a62e430e682b6c811736edba3cc918344053e35c092e12afd523198ed6244018450931776f8388e61a593f266476b6db19e";
      version = "1.0.0";
    };
  }

  {
    name = "io.opentracing/opentracing-util";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "opentracing-util";
      groupId = "io.opentracing";
      sha512 = "fbba29ff3d6018561077e9539ad9b72876424600eca3addb6a26981a4a3e52cb3dfd30f27945aff2b6c222c42454ce3ba67597171fd809a74c65b920f3a47c7a";
      version = "0.33.0";
    };
  }

  {
    name = "org.jsoup/jsoup";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "jsoup";
      groupId = "org.jsoup";
      sha512 = "8119ec44ee622c75f47a80dedeadf557744208dc49d3d9f579660929a0be3f71d3b8cb4aed64ee31f6bf7488bfc3516fb3980137d2fc63063caf46c9921f19f0";
      version = "1.7.2";
    };
  }

  {
    name = "nrepl/nrepl";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "nrepl";
      groupId = "nrepl";
      sha512 = "f9ffc647820e772428781cb4ccd4f84a7d903afffe64418af55c95bd7bc21e1722591ac425d1be366d8f4f4596debf0c1b006957848473d3c515f4187cd5cb86";
      version = "0.6.0";
    };
  }

  {
    name = "org.apache.maven.resolver/maven-resolver-connector-basic";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-resolver-connector-basic";
      groupId = "org.apache.maven.resolver";
      sha512 = "c8c14480ed89cf5d4cfec5dee7dae366b0b5d003cd835d4b1358add81253b205a53f6a62e5ecc145f09406fc8c57adb5fbf8f4521a044ac3d37b5fa8e67d4e21";
      version = "1.0.3";
    };
  }

  {
    name = "org.xerial/sqlite-jdbc";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "sqlite-jdbc";
      groupId = "org.xerial";
      sha512 = "efd1ea26d7f4f9bc66bf0d5f80234a0c535829bd498e4c5a0cab42873b58ac69133497d8c45689a1d3a39e657a2d0474d6b930c7bc415dd623801ee4a7354ffb";
      version = "3.25.2";
    };
  }

  {
    name = "org.apache.maven.resolver/maven-resolver-impl";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-resolver-impl";
      groupId = "org.apache.maven.resolver";
      sha512 = "3ffcac7ed4a05b2b58669ce05cc348acad627be3e0941ee28a9a665fea43a571d554005dd72ec51130083f792e31894880525df3cd6962d7c95885340abfb7da";
      version = "1.1.1";
    };
  }

  {
    name = "org.slf4j/slf4j-api";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "slf4j-api";
      groupId = "org.slf4j";
      sha512 = "a944468440a883bb3bde1f78d39abe43a90b6091fd9f1a70430ac10ea91b308b2ef035e4836d68ba97afdba2b04f62edece204278aaa416276a5f8596f8688af";
      version = "1.7.26";
    };
  }

  {
    name = "org.apache.maven/maven-model";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-model";
      groupId = "org.apache.maven";
      sha512 = "888a778101774265e0d8dbc96305274053d275c0b261e81c6aae8765f92b13d1e06c5aa8f51c7d53d5267e46041adc9218686e53fc47cc15563a1b178291bc16";
      version = "3.5.3";
    };
  }

  {
    name = "org.clojure/test.check";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "test.check";
      groupId = "org.clojure";
      sha512 = "ba7b5c915c1e7bd5e9e398f8cd9d74340ca3c4846483bae8f2191e40ea42bdd4d8019ec108c2bd64451f418abebed2258cf0ee5be597cc0bc8a02d772c6385ed";
      version = "0.10.0-RC1";
    };
  }

  {
    name = "org.apache.maven.resolver/maven-resolver-util";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-resolver-util";
      groupId = "org.apache.maven.resolver";
      sha512 = "91dcbb8184f06e64da35d40c7b96e854f7311b6232d74b4b6d3489a51e0c05ebbee44f59367ab118974cdb6c5b3747981a41869cc7372691b2c2e1d0daa2ffa3";
      version = "1.1.1";
    };
  }

  {
    name = "io.dropwizard.metrics/metrics-jmx";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "metrics-jmx";
      groupId = "io.dropwizard.metrics";
      sha512 = "706f7428b967923d2792b0587684e972b1404d663a6ac3d661772a57edf096f0de0efac8bbfcead4576c008b096c33f77499e8f193ccbb8b072d7aa6e6d7a40d";
      version = "4.1.0";
    };
  }

  {
    name = "io.forward/yaml";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "yaml";
      groupId = "io.forward";
      sha512 = "561cfe0e92689b95008948a0a8aa839b9932ffd13791fdbd9ce55e0b0e3c895be6441ccd050b62ff671c747373fcba1199246c8bfb4206cb05584d06dea99b7c";
      version = "1.0.9";
    };
  }

  {
    name = "me.raynes/fs";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "fs";
      groupId = "me.raynes";
      sha512 = "b72af0093c1feccf78ea0632ba523eca89436b0575abc0af484e03570011aa89f429f9820a9fc27f60da113d728d2bbc09ba26d3a0cdd63d9d9c7775643f6852";
      version = "1.4.6";
    };
  }

  {
    name = "org.clojure/core.memoize";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "core.memoize";
      groupId = "org.clojure";
      sha512 = "e1c5104ac20a22e670ccb80c085ce225c168802829668e91c316cbea4f8982431a9e2ac7bfa5e8477ef515088e9443763f44496633c8ee1e416f7eb8ddfefb88";
      version = "0.5.9";
    };
  }

  {
    name = "camel-snake-kebab/camel-snake-kebab";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "camel-snake-kebab";
      groupId = "camel-snake-kebab";
      sha512 = "3108a207378e8b6199ae6c71517fcc65dde97d2bab67d533a618c7ff50ea8b849ead3880857d00629d6c269499384b564ed43b631e6b06f283af94e8cae89144";
      version = "0.4.0";
    };
  }

  {
    name = "org.apache.maven/maven-repository-metadata";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-repository-metadata";
      groupId = "org.apache.maven";
      sha512 = "6d898373d483ac7f24ab0256406f4be45035f95a247bb19ac7102ea7f5e336976381c5125b30a7148bc9a8e1df6d27b456d1f8e9b55b99d9688e37dfd03733a3";
      version = "3.5.3";
    };
  }

  {
    name = "io.simplect/compose";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "compose";
      groupId = "io.simplect";
      sha512 = "0aceab86d4a97285ddd6d40abdeb5b9bea16a16b6509ef2fcd80e547d772185041e26abcc12ae11938d7b78fed175850f811d5cb2a2f0590524c2c11975bacd1";
      version = "0.7.27";
    };
  }

  {
    name = "org.clojure/data.priority-map";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "data.priority-map";
      groupId = "org.clojure";
      sha512 = "450e18bddb3962aee3a110398dc3e9c25280202eb15df2f25de6c26e99982e8de5cf535fe609948d190e312a00fad3ffc0b3a78b514ef66369577a4185df0a77";
      version = "0.0.7";
    };
  }

  {
    name = "org.apache.maven/maven-builder-support";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-builder-support";
      groupId = "org.apache.maven";
      sha512 = "1b2ca4427772532cfb93b4d643b17eca5843f1e1a9c4b26089eed8c10028344fb85d593d133fdffaff07b552c3027a9f24e1a92d68ed4696682be04069e84583";
      version = "3.5.3";
    };
  }

  {
    name = "org.slf4j/log4j-over-slf4j";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "log4j-over-slf4j";
      groupId = "org.slf4j";
      sha512 = "d0a13ae82823b921b308c897ec9a11ef86cb1b52dd81343f856224c65851f70eae0890a88550daa3a4ed57e7e2c150018a3cdc2345924a4e489a88827fc639b6";
      version = "1.7.14";
    };
  }

  {
    name = "org.clojure/core.cache";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "core.cache";
      groupId = "org.clojure";
      sha512 = "464c8503229dfcb5aa3c09cd74fa273ae82aff7a8f8daadb5c59a4224c7d675da4552ee9cb28d44627d5413c6f580e64df4dbfdde20d237599a46bb8f9a4bf6e";
      version = "0.6.5";
    };
  }

  {
    name = "rewrite-cljs/rewrite-cljs";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "rewrite-cljs";
      groupId = "rewrite-cljs";
      sha512 = "d87c07d510247e1b13dcb505436b3a43d8bb9a4bfebbd2ae0430249d2c8a859032affe2b2a4cda8f987e983f584fd999a3f9b87944d44b8837cdf4e2560c5ab9";
      version = "0.4.4";
    };
  }

  {
    name = "org.ow2.asm/asm-all";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "asm-all";
      groupId = "org.ow2.asm";
      sha512 = "462f31f8889c5ff07f1ce7bb1d5e9e73b7ec3c31741dc2b3da8d0b1a50df171e8e72289ff13d725e80ecbd9efa7e873b09870f5e8efb547f51f680d2339f290d";
      version = "4.2";
    };
  }

  {
    name = "org.clojure/core.async";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "core.async";
      groupId = "org.clojure";
      sha512 = "f80d61b51b5278c6c8b2b81ed45fa24ebaa42ade10e495fe34c5e1d827713eab33701a86dcc226a76e334365b0bd69d0c9da1e8b337f8752cd490145d3fc98b8";
      version = "0.4.500";
    };
  }

  {
    name = "com.fasterxml.jackson.dataformat/jackson-dataformat-smile";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "jackson-dataformat-smile";
      groupId = "com.fasterxml.jackson.dataformat";
      sha512 = "bc0b293687b9aa6641a6983d4c09d901294010fd0710c8163b0b283f06d044cfd2d7cebdb2590b170fefdde4751406b704955f59312af27d0e1f12f0d6c81ed8";
      version = "2.9.6";
    };
  }

  {
    name = "org.apache.maven/maven-artifact";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "maven-artifact";
      groupId = "org.apache.maven";
      sha512 = "a4cafc89d66c8f074c5c3f9454e5077abc0de6242c29904d8ee5816348af21b1006da67f3118478bc9eb067725c39be9b88e4a019eb8368c936f971f0499c2ca";
      version = "3.5.3";
    };
  }

  {
    name = "org.clojure/data.codec";
    path = pkgs.fetchMavenArtifact {
      inherit repos;
      artifactId = "data.codec";
      groupId = "org.clojure";
      sha512 = "cb6910fc0ee47ce6959a442ba3ef456dd91fe8589a576526d20fd661c8d305962f64a8e8ebde69f0bd00082027dbd0ac52b642fcd4950b4f0e5b7a1205f95138";
      version = "0.1.1";
    };
  }

  ];
  }
