{ stdenv
, lib
, substituteAll
, fetchurl
, pkg-config
, which
, gtk-doc
, docbook_xsl
, docbook_xml_dtd_412
, python3
, ncurses
, nautilus
, gtk3
, gnome
}:

stdenv.mkDerivation rec {
  pname = "nautilus-python";
  version = "1.2.3";

  outputs = [ "out" "dev" "doc" ];

  src = fetchurl {
    url = "mirror://gnome/sources/${pname}/${lib.versions.majorMinor version}/${pname}-${version}.tar.xz";
    sha256 = "161050sx3sdxqcpjkjcpf6wl4kx0jydihga7mcvrj9c2f8ly0g07";
  };

  patches = [
    # Make PyGObject’s gi library available.
    (substituteAll {
      src = ./fix-paths.patch;
      pythonPaths = lib.concatMapStringsSep ", " (pkg: "'${pkg}/${python3.sitePackages}'") [
        python3.pkgs.pygobject3
      ];
    })
  ];

  nativeBuildInputs = [
    pkg-config
    which
    gtk-doc
    docbook_xsl
    docbook_xml_dtd_412
  ];

  buildInputs = [
    python3
    ncurses # required by python3
    python3.pkgs.pygobject3
    nautilus
    gtk3 # required by libnautilus-extension
  ];

  makeFlags = [
    "PYTHON_LIB_LOC=${python3}/lib"
  ];

  PKG_CONFIG_LIBNAUTILUS_EXTENSION_EXTENSIONDIR = "${placeholder "out"}/lib/nautilus/extensions-3.0";

  passthru = {
    updateScript = gnome.updateScript {
      packageName = pname;
      attrPath = "gnome.${pname}";
      versionPolicy = "odd-unstable";
    };
  };

  meta = with lib; {
    description = "Python bindings for the Nautilus Extension API";
    homepage = "https://wiki.gnome.org/Projects/NautilusPython";
    license = licenses.gpl2Plus;
    maintainers = teams.gnome.members;
    platforms = platforms.unix;
  };
}
