{ lib, stdenv, fetchurl }:

let
  rev = "6faca61810d335c7837f320733fe8e15a1431fc2";

  # Don't use fetchgit as this is needed during Aarch64 bootstrapping
  configGuess = fetchurl {
    url = "https://git.savannah.gnu.org/cgit/config.git/plain/config.guess?id=${rev}";
    sha256 = "06wkkhpbx9slmknr2g7mcd8x3zsdhnmmay25l31h3rkdp1wkq7kx";
  };
  configSub = fetchurl {
    url = "https://git.savannah.gnu.org/cgit/config.git/plain/config.sub?id=${rev}";
    sha256 = "1qkph8cqanmgy3s4a18bm1a4vk62i8pf8cy5pc1hkpqwn4g6l0di";
  };
in stdenv.mkDerivation {
  pname = "gnu-config";
  version = "2021-01-25";

  buildCommand = ''
    mkdir -p $out
    cp ${configGuess} $out/config.guess
    cp ${configSub} $out/config.sub
  '';

  meta = with lib; {
    description = "Attempt to guess a canonical system name";
    homepage = "https://savannah.gnu.org/projects/config";
    license = licenses.gpl3;
    # In addition to GPLv3:
    #   As a special exception to the GNU General Public License, if you
    #   distribute this file as part of a program that contains a
    #   configuration script generated by Autoconf, you may include it under
    #   the same distribution terms that you use for the rest of that
    #   program.
    maintainers = [ maintainers.dezgeg ];
    platforms = platforms.all;
  };
}
