{ lib, stdenv
, build2
, fetchurl
, enableShared ? !stdenv.hostPlatform.isStatic
, enableStatic ? !enableShared
}:
stdenv.mkDerivation rec {
  pname = "libodb";
  version = "2.5.0-b.21";

  outputs = [ "out" "dev" "doc" ];

  src = fetchurl {
    url = "https://pkg.cppget.org/1/beta/odb/libodb-${version}.tar.gz";
    sha256 = "sha256-Q4HZ8zU5osZ9Phz59ZAjXh0dbB8ELBY5gMRbDnawCWs=";
  };

  nativeBuildInputs = [ build2 ];
  build2ConfigureFlags = [
    "config.bin.lib=${build2.configSharedStatic enableShared enableStatic}"
  ];

  doCheck = true;

  meta = with lib; {
    description = "Common ODB runtime library";
    longDescription = ''
      ODB is an object-relational mapping (ORM) system for C++. It provides
      tools, APIs, and library support that allow you to persist C++ objects
      to a relational database (RDBMS) without having to deal with tables,
      columns, or SQL and without manually writing any of the mapping code.
      For more information see:

      http://www.codesynthesis.com/products/odb/

      This package contains the common ODB runtime library. Every application
      that includes code generated by the ODB compiler will need to link to
      this library.
    '';
    homepage = "https://www.codesynthesis.com/products/odb/";
    changelog = "https://git.codesynthesis.com/cgit/odb/libodb/tree/NEWS";
    license = licenses.gpl2Only;
    maintainers = with maintainers; [ r-burns ];
    platforms = platforms.all;
  };
}
