{ lib, fetchFromGitLab, buildDunePackage }:

buildDunePackage rec {
  pname = "menhirLib";
  version = "20211128";

  src = fetchFromGitLab {
    domain = "gitlab.inria.fr";
    owner = "fpottier";
    repo = "menhir";
    rev = version;
    sha256 = "sha256-L/zfjPZfn9L7qqqqJGk3Ge52rvujOVPiL8jxfH5R60g=";
  };

  useDune2 = true;

  meta = with lib; {
    homepage = "http://pauillac.inria.fr/~fpottier/menhir/";
    description = "Runtime support library for parsers generated by Menhir";
    longDescription = ''
      Menhir is a LR(1) parser generator for the Objective Caml programming
      language.  That is, Menhir compiles LR(1) grammar specifications down
      to OCaml code.  Menhir was designed and implemented by François Pottier
      and Yann Régis-Gianas.
    '';
    license = with licenses; [ lgpl2Only ];
    maintainers = with maintainers; [ vbgl ];
  };
}
