{ lib
, buildPythonPackage
, fetchFromGitHub
, requests
, appdirs
, tabulate
, msgpack
, orjson
, semver
, packageurl-python
, pythonOlder
, pytestCheckHook
}:

buildPythonPackage rec {
  pname = "appthreat-vulnerability-db";
  version = "2.0.1";
  format = "setuptools";

  disabled = pythonOlder "3.7";

  src = fetchFromGitHub {
    owner = "AppThreat";
    repo = "vulnerability-db";
    rev = "v${version}";
    sha256 = "sha256-fqpBnxcRBBXsjJepxDuoDbT3hk5rXAvky11sIvQS9XI=";
  };

  propagatedBuildInputs = [
    requests
    appdirs
    tabulate
    msgpack
    orjson
    semver
    packageurl-python
  ];

  checkInputs = [
    pytestCheckHook
  ];

  postPatch = ''
    substituteInPlace pytest.ini \
      --replace " --cov-append --cov-report term --cov vdb" ""
  '';

  preCheck = ''
    export HOME=$(mktemp -d);
  '';

  disabledTests = [
    # Tests require network access
    "test_bulk_search"
    "test_download_recent"
  ];

  pythonImportsCheck = [
    "vdb"
  ];

  meta = with lib; {
    description = "Vulnerability database and package search for sources such as OSV, NVD, GitHub and npm";
    homepage = "https://github.com/appthreat/vulnerability-db";
    license = with licenses; [ mit ];
    maintainers = with maintainers; [ fab ];
  };
}
