{ lib
, stdenv
, fetchFromGitHub
, buildPythonPackage
, pytest
, xclip
, xvfb-run
}:

buildPythonPackage rec {
  pname = "pyclip";
  version = "0.5.4";

  src = fetchFromGitHub {
    owner = "spyoungtech";
    repo = pname;
    rev = "v${version}";
    sha256 = "19ff9cgnfx03mbmy5zpbdi986ppx38a5jf97vkqnic4g5sd1qyrn";
  };

  postPatch = ''
    substituteInPlace setup.py \
      --replace docs/README.md README.md
  '';

  checkInputs = [ pytest ] ++ lib.optionals stdenv.isLinux [ xclip xvfb-run ];

  checkPhase = ''
    runHook preCheck
    ${lib.optionalString stdenv.isLinux "xvfb-run -s '-screen 0 800x600x24'"} pytest tests
    runHook postCheck
  '';

  meta = with lib; {
    description = "Cross-platform clipboard utilities supporting both binary and text data";
    homepage = "https://github.com/spyoungtech/pyclip";
    license = licenses.asl20;
    maintainers = with maintainers; [ mcaju ];
  };
}
