{ lib
, buildPythonPackage
, fastjsonschema
, fetchFromGitHub
, fetchpatch
, future-typing
, inflection
, mypy
, orjson
, pandas
, pendulum
, poetry-core
, pydantic
, pytestCheckHook
, pythonOlder
, sqlalchemy
, typing-extensions
}:

buildPythonPackage rec {
  pname = "typical";
  version = "2.8.0";
  format = "pyproject";

  disabled = pythonOlder "3.7";

  src = fetchFromGitHub {
    owner = "seandstewart";
    repo = "typical";
    rev = "v${version}";
    hash = "sha256-DRjQmoZzWw5vpwIx70wQg6EO/aHqyX7RWpWZ9uOxSTg=";
  };

  nativeBuildInputs = [
    poetry-core
  ];

  propagatedBuildInputs = [
    inflection
    pendulum
    fastjsonschema
    orjson
    future-typing
  ] ++ lib.optionals (pythonOlder "3.10") [
    typing-extensions
  ];

  checkInputs = [
    pytestCheckHook
    mypy
    pydantic
    sqlalchemy
    pandas
  ];

  patches = [
    # Switch to poetry-core, https://github.com/seandstewart/typical/pull/193
    (fetchpatch {
      name = "switch-to-poetry-core.patch";
      url = "https://github.com/seandstewart/typical/commit/66b3c34f8969b7fb1f684f0603e514405bab0dd7.patch";
      sha256 = "sha256-c7qJOtHmJRnVEGl+OADB3HpjvMK8aYDD9+0gplOn9pQ=";
    })
  ];

  disabledTests = [
    # We use orjson
    "test_ujson"
    # ConstraintValueError: Given value <{'key...
    "test_tagged_union_validate"
  ];

  disabledTestPaths = [
    "benchmark/"
    # Tests are failing on Hydra
    "tests/mypy/test_mypy.py"
  ];

  pythonImportsCheck = [
    "typic"
  ];

  meta = with lib; {
    description = "Python library for runtime analysis, inference and validation of Python types";
    homepage = "https://python-typical.org/";
    license = licenses.mit;
    maintainers = with maintainers; [ kfollesdal ];
  };
}
