{ lib, buildGraalvmNativeImage, fetchurl }:

buildGraalvmNativeImage rec {
  pname = "jet";
  version = "0.1.0";

  src = fetchurl {
    url = "https://github.com/borkdude/${pname}/releases/download/v${version}/${pname}-${version}-standalone.jar";
    sha256 = "sha256-RCEIIZfPmOLW3akjEgaEas4xOtYxL6lQsxDv2szB8K4";
  };

  reflectionJson = fetchurl {
    url = "https://raw.githubusercontent.com/borkdude/${pname}/v${version}/reflection.json";
    sha256 = "sha256-mOUiKEM5tYhtpBpm7KtslyPYFsJ+Wr+4ul6Zi4aS09Q=";
  };

  extraNativeImageBuildArgs = [
    "-H:+ReportExceptionStackTraces"
    "-J-Dclojure.spec.skip-macros=true"
    "-J-Dclojure.compiler.direct-linking=true"
    "-H:IncludeResources=JET_VERSION"
    "-H:ReflectionConfigurationFiles=${reflectionJson}"
    "--initialize-at-build-time"
    "-H:Log=registerResource:"
    "--no-fallback"
    "--no-server"
  ];

  meta = with lib; {
    description = "CLI to transform between JSON, EDN and Transit, powered with a minimal query language";
    homepage = "https://github.com/borkdude/jet";
    license = licenses.epl10;
    maintainers = with maintainers; [ ericdallo ];
  };
}
