{ lib, stdenv, fetchurl, ncurses }:

stdenv.mkDerivation rec {
  pname = "typespeed";
  version = "0.6.5";
  buildInputs = [ ncurses ];
  src = fetchurl {
    url = "http://typespeed.sourceforge.net/typespeed-${version}.tar.gz";
    sha256 = "5c860385ceed8a60f13217cc0192c4c2b4705c3e80f9866f7d72ff306eb72961";
  };

  patches = [ ./typespeed-config-in-home.patch ];

  configureFlags = [ "--datadir=\${out}/share/" ];
  makeFlags = [ "CC=${stdenv.cc.targetPrefix}cc" ];

  meta = with lib; {
    description = "A curses based typing game";
    homepage = "http://typespeed.sourceforge.net/";
    license = licenses.gpl2;
    platforms = platforms.unix;
    maintainers = [ maintainers.auntie ];
  };
}
