{ lib, stdenv, fetchurl, pkg-config, mod_ca, apr, aprutil }:

stdenv.mkDerivation rec {
  pname = "mod_scep";
  version = "0.2.3";

  src = fetchurl {
    url = "https://redwax.eu/dist/rs/${pname}-${version}.tar.gz";
    sha256 = "1imddqyi81l90valvndx9r0ywn32ggijrdfrjmbx8j1abaccagrc";
  };

  nativeBuildInputs = [ pkg-config ];
  buildInputs = [ mod_ca apr aprutil ];
  inherit (mod_ca) configureFlags installFlags;

  meta = with lib; {
    description = "RedWax CA service modules for SCEP (Automatic ceritifcate issue/renewal)";

    homepage = "https://redwax.eu";
    license = licenses.asl20;
    platforms = platforms.unix;
    maintainers = with maintainers; [ dirkx ];
  };
}
