{lib, stdenv, fetchurl, erlang, pam, perl }:

stdenv.mkDerivation rec {
  pname = "yaws";
  version = "2.0.6";

  src = fetchurl {
    url = "http://yaws.hyber.org/download/${pname}-${version}.tar.gz";
    sha256 = "03nh97g7smsgm6sw5asssmlq7zgx6y2gnn7jn0lv2x5mkf5nzyb9";
  };

  # The tarball includes a symlink yaws -> yaws-1.95, which seems to be
  # necessary for importing erlang files
  unpackPhase = ''
    tar xzf $src
    cd $name
  '';

  configureFlags = [ "--with-extrainclude=${pam}/include/security" ];

  buildInputs = [ erlang pam perl ];

  postInstall = ''
    sed -i "s#which #type -P #" $out/bin/yaws
  '';

  meta = with lib; {
    description = "A high performance HTTP 1.1 server in Erlang";
    homepage = "http://yaws.hyber.org";
    license = licenses.bsd2;
    platforms = platforms.linux;
    maintainers = with maintainers; [ goibhniu ];
  };

}
