{ stdenv
, lib
, python3
, fetchurl
, autoreconfHook
, zlib
}:

stdenv.mkDerivation rec {
  pname = "pgadmin";
  version = "5.3";
  
  src = fetchurl {
    url = "https://ftp.postgresql.org/pub/pgadmin/pgadmin4/v${version}/source/pgadmin4-${version}.tar.gz";
    sha256 = "1a60p82dgwa7ggp3apzsvixksm8ifx8lxmkkkxh43yqdg4gahkcl";
  };

  # from Dockerfile
  CPPFLAGS="-DPNG_ARM_NEON_OPT=0";

  nativeBuildInputs = [
    autoreconfHook
  ];
  
  buildInputs = [
    zlib
    (python3.withPackages(p: with p; [
      cheroot
      # Flask
      passlib
      pytz
      simplejson
      six
      speaklater3
      sqlparse
      WTForms
      psutil
      psycopg2
      SQLAlchemy
      itsdanerous
      bcrypt
      cryptography
      sshtunnel
      idap3
      gssapi
    ]))
  ];
}
