{ lib, stdenv, fetchurl
, linkStatic ? with stdenv.hostPlatform; isStatic || isCygwin
, autoreconfHook
}:

# Note: this package is used for bootstrapping fetchurl, and thus
# cannot use fetchpatch! All mutable patches (generated by GitHub or
# cgit) that are needed here should be included directly in Nixpkgs as
# files.

stdenv.mkDerivation rec {
  pname = "bzip2";
  version = "1.0.6.0.2";

  /* We use versions patched to use autotools style properly,
      saving lots of trouble. */
  src = fetchurl {
    urls = map
      (prefix: prefix + "/people/sbrabec/bzip2/tarballs/${pname}-${version}.tar.gz")
      [
        "http://ftp.uni-kl.de/pub/linux/suse"
        "ftp://ftp.hs.uni-hamburg.de/pub/mirrors/suse"
        "ftp://ftp.mplayerhq.hu/pub/linux/suse"
        "http://ftp.suse.com/pub" # the original patched version but slow
      ];
    sha256 = "sha256-FnhwNy4OHe8d5M6iYCClkxzcB/EHXg0veXwv43ZlxbA=";
  };

  nativeBuildInputs = [ autoreconfHook ];

  patches = [
    ./CVE-2016-3189.patch
    ./cve-2019-12900.patch
  ];

  postPatch = ''
    sed -i -e '/<sys\\stat\.h>/s|\\|/|' bzip2.c
  '';

  outputs = [ "bin" "dev" "out" "man" ];

  configureFlags =
    lib.optionals linkStatic [ "--enable-static" "--disable-shared" ];

  enableParallelBuilding = true;

  meta = with lib; {
    description = "High-quality data compression program";
    homepage = "https://www.sourceware.org/bzip2";
    changelog = "https://sourceware.org/git/?p=bzip2.git;a=blob;f=CHANGES;hb=HEAD";
    license = licenses.bsdOriginal;
    platforms = platforms.all;
    maintainers = with maintainers; [ mic92 ];
  };
}
