#!/usr/bin/env nix-shell
#!nix-shell -p nix -i bash --pure

# Does like `maintainers/scripts/debian-patches.sh`, but specialized for
# grub1 patches, and using the new salsa service.

# Most common usage: `pkgs/tools/misc/grub/grub1.patches.sh pkgs/tools/misc/grub/grub1.patches.nix`
# That is, after updating the script with the new list from the series file,
# removing (by commenting) patches as required.

set -e
set -u

# https://salsa.debian.org/grub-team/grub-legacy/tree/master/debian/patches
SERIES=(
    snapshot.patch
    menu.lst_gnu-hurd.patch
    graphics.patch
    raid.patch
    raid_cciss.patch
    xfs_freeze.patch
    2gb_limit.patch
    grub-special_device_names.patch
    grub-xvd_drives.patch
    initrd_max_address.patch
    splashimage_help.patch
    grub-install_addsyncs.patch
    grub-install_regexp.patch
    grub-install_aoe_support.patch
    grub-install_xvd.patch
    geometry-26kernel.patch
    print_func.patch
    mprotect.patch
    savedefault.patch
    find-grub-dir.patch
    intelmac.patch
    crossreference_manpages.patch
    ext3_256byte_inode.patch
    # Breaks on NixOS.
    #use_grub-probe_in_grub-install.patch
    objcopy-absolute.patch
    no-reorder-functions.patch

    # We aren't building amd64 binaries, see #244498
    #fix_amd64_compile.patch
    modern-automake.patch
    no-combine-stack-adjustments.patch
    no-pie.patch
)

# Revision mapping to current tip of the 0.97-73 branch.
rev="1dad5507d74ef97fdd3c6cf2a028084f6f2850c3"
prefix="https://salsa.debian.org/grub-team/grub-legacy/raw/${rev}/debian/patches"
FILE="$1"
shift

cat <<EOF > "$FILE"
# Generated by grub1-patches.sh
let
  prefix = "${prefix}";
in
[
EOF

for PATCH in "${SERIES[@]}"; do
    URL="$prefix/$PATCH"
    HASH="$(nix-prefetch-url "$URL")"
    echo "{ url = \"\${prefix}/$PATCH\"; sha256 = \"$HASH\"; }" >> "$FILE"
done
echo "]" >> "$FILE"
