{ lib, buildGoModule, fetchFromGitHub, kubernetes-helm }:

buildGoModule rec {
  pname = "telepresence2";
  version = "2.4.10";

  src = fetchFromGitHub {
    owner = "telepresenceio";
    repo = "telepresence";
    rev = "v${version}";
    sha256 = "sha256-OM0kMQYYHjk17x4VmrIXyTq/DxXnTrt6oRHEdV+1+Ns=";
  };

  # The Helm chart is go:embed'ed as a tarball in the binary.
  # That tarball is generated by running ./build-aux/package_embedded_chart/main.go,
  # which tries to invoke helm from tools/bin/helm.
  # Oh well…
  preBuild = ''
    mkdir -p tools/bin
    ln -sfn ${kubernetes-helm}/bin/helm tools/bin/helm
    go run ./build-aux/package_embedded_chart/main.go ${src.rev}
  '';

  vendorSha256 = "sha256-J7Qj0g479K6k0pXmZzQ3T4VG4Vdj7Sc9Xhuy4Ke/xkU=";

  ldflags = [
    "-s" "-w" "-X=github.com/telepresenceio/telepresence/v2/pkg/version.Version=${src.rev}"
  ];

  subPackages = [ "cmd/telepresence" ];

  meta = with lib; {
    description = "Local development against a remote Kubernetes or OpenShift cluster";
    homepage = "https://www.getambassador.io/docs/telepresence/2.1/quick-start/";
    license = licenses.asl20;
    maintainers = with maintainers; [ mausch ];
  };
}
