{ lib
, buildPythonApplication
, fetchFromGitHub
, jsonschema
, plotly
, pytest
, pytest-xdist
, pytest-cov
, pytest-asyncio
, beautifulsoup4
, pyyaml
, isort
, py
, jinja2
, rpmfile
, reportlab
, zstandard
, rich
, aiohttp
, toml
, distro
  # aiohttp[speedups]
, aiodns
, brotlipy
, cchardet
, pillow
, pytestCheckHook
}:
buildPythonApplication rec {
  pname = "cve-bin-tool";
  version = "3.0";

  src = fetchFromGitHub {
    owner = "intel";
    repo = "cve-bin-tool";
    rev = "v${version}";
    sha256 = "1fmdnlhi03fdr4d4n7ydf6m0gx0cl77n3db8ldbs3m9zryblhzpr";
  };

  # Wants to open a sqlite database, access the internet, etc
  doCheck = false;

  propagatedBuildInputs = [
    jsonschema
    plotly
    pytest
    pytest-xdist
    pytest-cov
    pytest-asyncio
    beautifulsoup4
    pyyaml
    isort
    py
    jinja2
    rpmfile
    reportlab
    zstandard
    rich
    aiohttp
    toml
    distro
    # aiohttp[speedups]
    aiodns
    brotlipy
    cchardet
    # needed by brotlipy
    pillow
  ];

  checkInputs = [
    pytestCheckHook
  ];

  pythonImportsCheck = [
    "cve_bin_tool"
  ];

  meta = with lib; {
    description = "CVE Binary Checker Tool";
    homepage = "https://github.com/intel/cve-bin-tool";
    license = licenses.gpl3Only;
    maintainers = teams.determinatesystems.members;
  };
}
