{ lib
, fetchFromGitHub
, python3
}:

python3.pkgs.buildPythonApplication rec {
  pname = "maigret";
  version = "0.4.1";

  src = fetchFromGitHub {
    owner = "soxoj";
    repo = pname;
    rev = "v${version}";
    sha256 = "0igfxg238awdn1ly8s3r655yi3gpxink7g2hr6xb0c1nrm7z0kad";
  };

  propagatedBuildInputs = with python3.pkgs; [
    aiodns
    aiohttp
    aiohttp-socks
    arabic-reshaper
    async-timeout
    attrs
    beautifulsoup4
    certifi
    chardet
    colorama
    future
    html5lib
    idna
    jinja2
    lxml
    markupsafe
    mock
    multidict
    networkx
    pycountry
    pypdf2
    pysocks
    python-bidi
    pyvis
    requests
    requests-futures
    six
    socid-extractor
    soupsieve
    stem
    torrequest
    tqdm
    typing-extensions
    webencodings
    xhtml2pdf
    xmind
    yarl
  ];

  checkInputs = with python3.pkgs; [
    pytest-httpserver
    pytest-asyncio
    pytestCheckHook
  ];

  postPatch = ''
    # Remove all version pinning
    sed -i -e "s/==[0-9.]*//" requirements.txt
    # We are not build for Python < 3.7
    sed -i -e '/future-annotations/d' requirements.txt
    # We can't work with dummy packages
    sed -i -e 's/bs4/beautifulsoup4/g' requirements.txt
  '';

  disabledTests = [
    # Tests require network access
    "test_extract_ids_from_page"
    "test_import_aiohttp_cookies"
    "test_maigret_results"
    "test_pdf_report"
    "test_self_check_db_negative_enabled"
    "test_self_check_db_positive_enable"
  ];

  pythonImportsCheck = [
    "maigret"
  ];

  meta = with lib; {
    description = "Tool to collect details about an username";
    homepage = "https://maigret.readthedocs.io";
    license = with licenses; [ mit ];
    maintainers = with maintainers; [ fab ];
  };
}
