{ lib, stdenv, fetchurl, xz, coreutils ? null }:

# Note: this package is used for bootstrapping fetchurl, and thus
# cannot use fetchpatch! All mutable patches (generated by GitHub or
# cgit) that are needed here should be included directly in Nixpkgs as
# files.

stdenv.mkDerivation rec {
  pname = "diffutils";
  version = "3.8";

  src = fetchurl {
    url = "mirror://gnu/diffutils/diffutils-${version}.tar.xz";
    sha256 = "sha256-pr3X0bMSZtEcT03mwbdI1GB6sCMa9RiPwlM9CuJDj+w=";
  };

  outputs = [ "out" "info" ];

  nativeBuildInputs = [ xz.bin ];
  /* If no explicit coreutils is given, use the one from stdenv. */
  buildInputs = [ coreutils ];

  configureFlags =
    # "pr" need not be on the PATH as a run-time dep, so we need to tell
    # configure where it is. Covers the cross and native case alike.
    lib.optional (coreutils != null) "PR_PROGRAM=${coreutils}/bin/pr"
    ++ lib.optional (stdenv.buildPlatform != stdenv.hostPlatform) "gl_cv_func_getopt_gnu=yes";

  meta = with lib; {
    homepage = "https://www.gnu.org/software/diffutils/diffutils.html";
    description = "Commands for showing the differences between files (diff, cmp, etc.)";
    license = licenses.gpl3;
    platforms = platforms.unix;
  };
}
