#!/nix/store/5kfq0gsyrzh3491wwxc9mp9sgrqq4b70-nodejs-17.5.0/bin/node

'use strict'

const fs = require('fs')
const path = require('path')

let cwd = process.env.INIT_CWD || process.cwd()
let pjson

while (!pjson && cwd !== '/') {
  if (fs.existsSync(path.join(cwd, 'package.json'))) {
    pjson = path.join(cwd, 'package.json')
  } else {
    cwd = path.dirname(cwd)
  }
}

if (!pjson) {
  throw new Error('No top-level package.json found!')
}

const { template } = require(pjson)
const e = template.extends
delete template.extends

const { extendRecursivly } = require('.')

extendRecursivly(cwd, template, e)
