import { spawn as cpSpawn } from 'node:child_process'
import bl from 'bl'
import debug from 'debug'

import { join } from 'path'
import { readFileSync, writeFileSync, existsSync } from 'node:fs'

const log = debug('xup')

export const p = (...a) => join(...a)
export const r = (...a) => String(readFileSync(p(...a)))
export const w = (...a) => {
  const v = a.pop()
  return writeFileSync(p(...a), v)
}

export const info = console.log.bind(console) // eslint-disable-line no-console
export const error = console.error.bind(console) // eslint-disable-line no-console
export const die = (...a) => {
  error(...a)
  process.exit(2)
}

export const e = (...a) => existsSync(p(...a))

export const STORE = '/var/lib/xup'
export const NIXOS = '/etc/nixos'
export const GC = '/var/lib/xup/gc'
export const GCROOT = '/nix/var/nix/gcroots'
export const ETC = '/etc'

export async function spawn (cmd, args, catchStdio = false, ignoreFail = false, options = {}) { // eslint-disable-line max-params
  return new Promise((resolve, reject) => {
    const opt = [cmd, args, { stdio: catchStdio ? 'pipe' : 'inherit', ...options }]
    log('spawn %o', opt)
    const p = cpSpawn(...opt)

    if (catchStdio) {
      p.stdout = p.stdout.pipe(bl())
      p.stderr = p.stderr.pipe(bl())
    }

    p.once('exit', (code, sig) => {
      if ((code || sig) && !ignoreFail) {
        return reject(new Error(`Failed with ${code || sig}`))
      }

      return resolve({ stdout: String(p.stdout), stderr: String(p.stderr), code, sig })
    })
  })
}
